
##############################
# Country definition for SOV #
##############################

province =
{ id         = 133
  anti_air   = { size = 4 current_size = 4 }
  naval_base = { size = 7 current_size = 7 }
  air_base   = { size = 4 current_size = 4 }
}              # Murmansk
province =
{ id         = 154
  anti_air   = { size = 4 current_size = 4 }
  naval_base = { size = 3 current_size = 3 }
  air_base   = { size = 4 current_size = 4 }
}              # Archangelsk
province =
{ id          = 163
  air_base    = { size = 4 current_size = 4 }
  landfort    = { size = 5 current_size = 5 }
  anti_air    = { size = 3 current_size = 3 }
}               # Stalingrad
province =
{ id          = 175
  air_base    = { size = 10 current_size = 10 }
  landfort    = { size = 5 current_size = 5 }
  anti_air    = { size = 4 current_size = 4 }
}               # Moscow
province =
{ id       = 181
  air_base = { size = 3 current_size = 3 }
  anti_air = { size = 1 current_size = 1 }
}            # Kaluga
province =
{ id          = 187
  synthetic_rares = { size = 1 current_size = 1 }
  anti_air    = { size = 6 current_size = 6 }
  naval_base  = { size = 10 current_size = 10 }
  air_base    = { size = 10 current_size = 10 }
  landfort    = { size = 5 current_size = 5 }
  coastalfort = { size = 5 current_size = 5 }
}               # Leningrad
province = { id = 191 anti_air = { size = 1 current_size = 1 } } # Porkhov
province =
{ id       = 201
  air_base = { size = 6 current_size = 6 }
}            # Opochka
province =
{ id       = 217
  air_base = { size = 2 current_size = 2 }
  anti_air = { size = 2 current_size = 2 }
}            # Vitebsk
province = { id = 219 anti_air = { size = 3 current_size = 3 } } # Smolensk
province =
{ id       = 220
  air_base = { size = 8 current_size = 8 }
}            # Mogilev
province =
{ id       = 233
  air_base = { size = 4 current_size = 4 }
  anti_air = { size = 3 current_size = 3 }
}            # Odessa
province = { id = 234 ic = 1 } # Kherson
province = { id = 236 ic = 1 } # Krivoy Rog
province =
{ id       = 238
  ic	      = 2
  air_base = { size = 8 current_size = 8 }
  anti_air = { size = 3 current_size = 3 }
}            # Kiev
province = { id = 246 anti_air = { size = 2 current_size = 2 } } # Zaporozhye
province =
{ id       = 248
  air_base = { size = 2 current_size = 2 }
  anti_air = { size = 1 current_size = 1 }
}            # Kharkov
province =
{ id          = 253
  anti_air    = { size = 6 current_size = 6 }
  naval_base  = { size = 10 current_size = 10 }
  air_base    = { size = 6 current_size = 6 }
  landfort    = { size = 3 current_size = 3 }
  coastalfort = { size = 5 current_size = 5 }
}               # Sevastopol
province =
{ id       = 258
  air_base = { size = 4 current_size = 4 }
  anti_air = { size = 2 current_size = 2 }
}            # Rostov
province = { id = 263 anti_air = { size = 1 current_size = 1 } } # Svoboda
province =
{ id       = 264
  air_base = { size = 2 current_size = 2 }
}            # Pavlovsk
province =
{ id       = 273
  air_base = { size = 2 current_size = 2 }
}            # Gomel
province = { id = 277 anti_air = { size = 2 current_size = 2 } } # Bryansk
province =
{ id       = 282
  air_base = { size = 5 current_size = 5 }
}            # Orel
province =
{ id       = 289
  air_base = { size = 2 current_size = 2 }
}            # Demyansk
province =
{ id       = 1163
  air_base = { size = 1 current_size = 1 }
}            # Yakutsk
province =
{ id         = 1175
  anti_air   = { size = 2 current_size = 2 }
  naval_base = { size = 3 current_size = 3 }
}              # Ocha
province =
{ id       = 1368
  air_base = { size = 1 current_size = 1 }
}            # Komsomolsk-na-Amure
province =
{ id          = 1372
  anti_air    = { size = 5 current_size = 5 }
  naval_base  = { size = 10 current_size = 10 }
  air_base    = { size = 10 current_size = 10 }
  landfort    = { size = 1 current_size = 1 }
  coastalfort = { size = 3 current_size = 3 }
}               # Vladivostok
province =
{ id       = 1416
  air_base = { size = 3 current_size = 3 }
}            # Irkutsk
province = { id = 1422 ic = 6 } # Alma-Ata
province = { id = 1427 ic = 3 } # Tashkent
province = { id = 1429 ic = 5 } # Frunze
province = { id = 1485 ic = 4 } # Stalinabad
province = { id = 1490 ic = 3 } # Ashgabat
province =
{ id       = 1523
  air_base = { size = 2 current_size = 2 }
}            # Tynda
province =
{ id         = 1525
  anti_air   = { size = 2 current_size = 2 }
  naval_base = { size = 1 current_size = 1 }
  air_base   = { size = 1 current_size = 1 }
}              # Okhotsk
province =
{ id       = 1538
  air_base = { size = 1 current_size = 1 }
}            # Severo-Yenisejsk
province =
{ id       = 1544
  air_base = { size = 2 current_size = 2 }
}            # Tomsk
province = { id = 1548 ic = 6 } # Novosibirsk
province =
{ id       = 1550
  air_base = { size = 2 current_size = 2 }
}            # Semipalatinsk
province =
{ id       = 1552
  air_base = { size = 1 current_size = 1 }
}            # Omsk
province = { id = 1572 ic = 4 } # Sverdlovsk
province =
{ id       = 1574
  air_base = { size = 1 current_size = 1 }
}            # Chelyabinsk
province =
{ id       = 1827
  air_base = { size = 2 current_size = 2 }
}            # Naberezhnye Chelny
province =
{ id       = 1828
  air_base = { size = 4 current_size = 4 }
  synthetic_rares = { size = 1 current_size = 1 }
}            # Kuybyshev
province =
{ id       = 1832
  air_base = { size = 3 current_size = 3 }
}            # Saratov
province =
{ id       = 1838
  anti_air = { size = 2 current_size = 2 }
  air_base = { size = 4 current_size = 4 }
}            # Astrakhan
province =
{ id       = 1839
  air_base = { size = 2 current_size = 2 }
}            # Novouzensk
province =
{ id         = 1848
  anti_air   = { size = 2 current_size = 2 }
  naval_base = { size = 3 current_size = 3 }
  air_base   = { size = 4 current_size = 4 }
}              # Batum
province = { id = 1850 ic = 7 } # Tblisi
province = { id = 1856 ic = 5 } # Yerevan

#####################
# Country main data #
#####################

country =
{ tag                    = SOV
  regular_id             = RUS
  intrinsic_gov_type     = leninist
  capital                = 175
  #ground_def_eff         = 0.200
  # Resource Reserves
  energy                 = 1000
  metal                  = 1000
  rare_materials         = 500
  oil                    = 500
  supplies               = 500
  money                  = 30
  manpower               = 3000
  dissent                = 15
  transports             = 140
  escorts                = 30
  diplomacy =
  { relation =
    { tag        = AFG
      value      = 1
      guaranteed = { day = 16 month = may year = 1935 }
    }
    relation = { tag = BRA value = -50 }
    relation =
    { tag        = BUL
      value      = 15
      guaranteed = { day = 16 month = may year = 1935 }
    }
    relation = { tag = CHC value = 100 }
    relation = { tag = CZE value = 100 }
    relation = { tag = ENG value = -25 }
    relation =
    { tag        = EST
      value      = -30
      guaranteed = { day = 16 month = may year = 1935 }
    }
    relation = { tag = FIN value = 1 }
    relation =
    { tag        = FRA
      value      = 100
      guaranteed = { day = 7 month = january year = 1935 }
    }
    relation = { tag = GER value = 1 }
    relation = { tag = GRE value = 15 }
    relation = { tag = IRE value = 1 }
    relation = { tag = JAP value = -10 }
    relation =
    { tag        = LAT
      value      = -30
      guaranteed = { day = 16 month = may year = 1935 }
    }
    relation =
    { tag        = LIT
      value      = -30
      guaranteed = { day = 16 month = may year = 1935 }
    }
    relation = { tag = MON value = 150 access = yes }
    relation =
    { tag        = PER
      value      = -20
      guaranteed = { day = 16 month = may year = 1935 }
    }
    relation = { tag = POL value = -50 }
    relation = { tag = ROM value = 1 }
    relation = { tag = SAU value = 1 }
    relation = { tag = SIK value = 125 }
    relation = { tag = SPR value = -10 }
    relation =
    { tag        = TAN
      value      = 200
      guaranteed = { day = 16 month = may year = 1935 }
      access     = yes
    }
    relation =
    { tag        = TUR
      value      = 100
      guaranteed = { day = 30 month = december year = 1935 }
    }
    relation = { tag = URU value = -100 }
    relation = { tag = USA value = 35 }
    relation =
    { tag        = SCH
      value      = 1
      guaranteed = { day = 16 month = may year = 1935 }
    }
  }
  SpyInfo                = { country = "SOV" NumberOfSpies = 5 }
  SpyInfo                = { country = "ENG" NumberOfSpies = 2 }
  SpyInfo                = { country = "FRA" NumberOfSpies = 1 }
  SpyInfo                = { country = "GER" NumberOfSpies = 1 }
  SpyInfo                = { country = "CZE" NumberOfSpies = 1 }
  SpyInfo                = { country = "AUS" NumberOfSpies = 1 }
  SpyInfo                = { country = "SPR" NumberOfSpies = 2 }
  SpyInfo                = { country = "POL" NumberOfSpies = 3 }
  SpyInfo                = { country = "SWE" NumberOfSpies = 2 }
  SpyInfo                = { country = "NOR" NumberOfSpies = 1 }
  SpyInfo                = { country = "FIN" NumberOfSpies = 3 }
  SpyInfo                = { country = "YUG" NumberOfSpies = 3 }
  SpyInfo                = { country = "HUN" NumberOfSpies = 2 }
  SpyInfo                = { country = "BUL" NumberOfSpies = 3 }
  SpyInfo                = { country = "BEL" NumberOfSpies = 1 }
  SpyInfo                = { country = "DEN" NumberOfSpies = 1 }
  SpyInfo                = { country = "CXB" NumberOfSpies = 2 }
  SpyInfo                = { country = "MON" NumberOfSpies = 3 }
  SpyInfo                = { country = "CGX" NumberOfSpies = 1 }
  SpyInfo                = { country = "USA" NumberOfSpies = 3 }
  SpyInfo                = { country = "GUA" NumberOfSpies = 1 }
  SpyInfo                = { country = "GRE" NumberOfSpies = 1 }
  SpyInfo                = { country = "CYN" NumberOfSpies = 3 }
  SpyInfo                = { country = "CSX" NumberOfSpies = 1 }
  SpyInfo                = { country = "JAP" NumberOfSpies = 3 }
  SpyInfo                = { country = "ROM" NumberOfSpies = 2 }
  SpyInfo                = { country = "LIT" NumberOfSpies = 2 }
  SpyInfo                = { country = "LUX" NumberOfSpies = 1 }
  SpyInfo                = { country = "POR" NumberOfSpies = 1 }
  SpyInfo                = { country = "ITA" NumberOfSpies = 3 }
  SpyInfo                = { country = "CHI" NumberOfSpies = 2 }
  SpyInfo                = { country = "SCH" NumberOfSpies = 1 }
  nationalprovinces      = { 1372 1373 1371 1370 1369 1367 1366 1527 1529 1528 1526 1523 1410 1525 1524 1409 1164 1165 1166 1167 1170 1171 1172 1405
                             1174 1175 1522 1521 1384 1383 1520 1416 1415 1414 1413 1162 1412 1411 1163 1159 1160 1158 1417 1558 1557 1423 1556 1550
                             1549 1547 1546 1559 1561 1560 1562 1563 1532 1537 1538 1545 1544 1548 1543 1540 1539 1536 1535 1533 1534 1157 1531 1156
                             1155 1154 1565 1564 1571 1597 1598 1554 1555 1553 1552 1594 1596 1573 1593 1592 1591 1590 1589 1588 1587 1424 1586 1585
                             1584 1583 1581 1576 1575 1574 1572 1566 1567 1570 1577 1578 1580 1582 1579 1569 1568 1150 1151 1152 1153 1773 1772 1771
                             154  1840 1841 165  153  151  152  150  135  134  133  1838 1847 1857 1849 1850 1848 1845 1844 1846 1843 255  256  257 
                             270  1842 1837 271  164  1833 1834 1836 1839 1827 1828 1835 1829 1832 1831 1830 252  253  254  1777 1778 1776 1775 1780
                             1781 1782 1783 1774 163  162  161  160  159  157  156  158  155  169  168  167  179  180  166  178  177  170  171  172 
                             173  174  175  176  181  182  183  184  190  191  189  185  186  187  188  192  200  201  212  225  226  227  228  231 
                             232  233  234  251  250  235  236  237  238  239  240  220  272  241  273  274  275  276  277  278  279  280  281  282 
                             283  284  249  258  259  260  248  247  243  262  261  269  268  267  266  265  264  263  1490 1491 1485 1487 1488 1427
                             1428 1426 1425 1429 94   215  216  217  218  219  221  242  244  245  246  285  286  287  288  289  1149 1161 1368 1422
                             1489 1856 1858 1907 1541 1542 1551 1874 1176
                           }
  ownedprovinces         = { 1372 1373 1371 1370 1369 1367 1366 1527 1529 1528 1526 1523 1410 1525 1524 1409 1164 1165 1166 1167 1170 1171 1172 1405
                             1175 1522 1521 1384 1383 1520 1416 1415 1414 1413 1162 1412 1411 1163 1159 1160 1158 1417 1558 1557 1423 1556 1550 1549
                             1547 1546 1559 1561 1560 1562 1563 1532 1537 1538 1545 1544 1548 1543 1540 1539 1536 1535 1533 1534 1157 1531 1156 1155
                             1154 1565 1564 1571 1597 1598 1554 1555 1553 1552 1594 1596 1573 1593 1592 1591 1590 1589 1588 1587 1424 1586 1585 1584
                             1583 1581 1576 1575 1574 1572 1566 1567 1570 1577 1578 1580 1582 1579 1569 1568 1150 1151 1152 1153 1773 1772 1771 154 
                             1840 1841 165  153  151  152  150  135  134  133  1838 1847 1857 1849 1850 1848 1845 1844 1846 1843 255  256  257  270 
                             1842 1837 271  164  1833 1834 1836 1839 1827 1828 1835 1829 1832 1831 1830 252  253  254  1777 1778 1776 1775 1780 1781
                             1782 1783 1774 163  162  161  160  159  157  156  158  155  169  168  167  179  180  166  178  177  170  171  172  173 
                             174  175  176  181  182  183  184  190  191  189  185  186  187  188  192  200  201  212  225  226  227  228  231  232 
                             233  234  251  250  235  236  237  238  239  240  220  272  241  273  274  275  276  277  278  279  280  281  282  283 
                             284  249  258  259  260  248  247  243  262  261  269  268  267  266  265  264  263  1490 1491 1485 1487 1488 1427 1428
                             1426 1425 1429 94   215  216  217  218  219  221  242  244  245  246  285  286  287  288  289  1149 1161 1368 1422 1489
                             1856 1858 1907 1541 1542 1551 1874
                           }
  controlledprovinces    = { 1372 1373 1371 1370 1369 1367 1366 1527 1529 1528 1526 1523 1410 1525 1524 1409 1164 1165 1166 1167 1170 1171 1172 1405
                             1175 1522 1521 1384 1383 1520 1416 1415 1414 1413 1162 1412 1411 1163 1159 1160 1158 1417 1558 1557 1423 1556 1550 1549
                             1547 1546 1559 1561 1560 1562 1563 1532 1537 1538 1545 1544 1548 1543 1540 1539 1536 1535 1533 1534 1157 1531 1156 1155
                             1154 1565 1564 1571 1597 1598 1554 1555 1553 1552 1594 1596 1573 1593 1592 1591 1590 1589 1588 1587 1424 1586 1585 1584
                             1583 1581 1576 1575 1574 1572 1566 1567 1570 1577 1578 1580 1582 1579 1569 1568 1150 1151 1152 1153 1773 1772 1771 154 
                             1840 1841 165  153  151  152  150  135  134  133  1838 1847 1857 1849 1850 1848 1845 1844 1846 1843 255  256  257  270 
                             1842 1837 271  164  1833 1834 1836 1839 1827 1828 1835 1829 1832 1831 1830 252  253  254  1777 1778 1776 1775 1780 1781
                             1782 1783 1774 163  162  161  160  159  157  156  158  155  169  168  167  179  180  166  178  177  170  171  172  173 
                             174  175  176  181  182  183  184  190  191  189  185  186  187  188  192  200  201  212  225  226  227  228  231  232 
                             233  234  251  250  235  236  237  238  239  240  220  272  241  273  274  275  276  277  278  279  280  281  282  283 
                             284  249  258  259  260  248  247  243  262  261  269  268  267  266  265  264  263  1490 1491 1485 1487 1488 1427 1428
                             1426 1425 1429 94   215  216  217  218  219  221  242  244  245  246  285  286  287  288  289  1149 1161 1368 1422 1489
                             1856 1858 1907 1541 1542 1551 1874
                           }
  # Rocket Test and Research Facility
  # Air Doctrines 1936
  # ################
  techapps               = { 5550  9010  9020  9030  9040  4010  4020  4120  4130  2010  2020  2030  2150  2290  2300  2310  2320  2450  5010  5080 
                             5090  5190  1010  1110  1190  1230  1020  1200  1210  1220  1310  6210  6300  2400  2040  8010  8020  8030  8040  8050 
                             8070  3010  3020  3030  3070  3080  3130  3140  3190  3250  3260  3270  3400  3410  3420  14000 5290
                           }
  blueprints             = { 1070 }
  policy =
  { date              = { year = 0 month = january day = 0 }
    democratic        = 1
    political_left    = 10
    freedom           = 1
    free_market       = 1
    professional_army = 1
    defense_lobby     = 6
    interventionism   = 4
  }
  headofstate            = { type = 9 id = 4001 }
  headofgovernment       = { type = 9 id = 4002 }
  foreignminister        = { type = 9 id = 4003 }
  armamentminister       = { type = 9 id = 4004 }
  ministerofsecurity     = { type = 9 id = 4005 }
  ministerofintelligence = { type = 9 id = 4006 }
  chiefofstaff           = { type = 9 id = 4007 }
  chiefofarmy            = { type = 9 id = 4008 }
  chiefofnavy            = { type = 9 id = 4009 }
  chiefofair             = { type = 9 id = 4010 }

  nationalidentity = "policy_identity_defensive"
	socialpolicy = "policy_social_conformism"
	nationalculture = "policy_culture_civic"

 ########################################
	### Soviet Land OOB ###
 ########################################
  landunit =
  { id       = { type = 10848 id = 1 }
    name     = "1@BRc"
    location = 187
    division =
    { id       = { type = 10848 id = 2 }
      name     = "163ԉtc"
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
    division =
    { id       = { type = 10848 id = 3 }
      name     = "177etc"
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 4 }
      name     = "191etc"
      strength = 60
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 5 }
      name     = "8u~[XJvetc"
      strength = 60
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 6 }
    name     = "7R"
    location = 152
    division =
    { id       = { type = 10848 id = 7 }
      name     = "54etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 8 }
      name     = "71etc"
      strength = 80
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 9 }
    name     = "14R"
    location = 191
    division =
    { id       = { type = 10848 id = 10 }
      name     = "122etc"
      strength = 80
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 11 }
      name     = "104etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 12 }
      name     = "14uNHWXJvetc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 13 }
      name     = "1Ԏtc"
      strength = 30
      type     = light_armor
      model    = 0
    }
  }
  landunit =
  { id       = { type = 10848 id = 14 }
    name     = "23R"
    location = 216
    division =
    { id       = { type = 10848 id = 15 }
      name     = "142etc"
      strength = 80
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 16 }
      name     = "43etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 17 }
      name     = "198ԉetc"
      strength = 80
      type     = motorized
      extra    = artillery
    }
  }
  landunit =
  { id       = { type = 10848 id = 18 }
    name     = "8R"
    location = 219
    division =
    { id       = { type = 10848 id = 19 }
      name     = "10etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 20 }
      name     = "48etc"
      strength = 80
      extra    = artillery
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 21 }
      name     = "202ԉetc"
      strength = 80
      type     = motorized
      extra    = engineer
    }
  }
  landunit =
  { id       = { type = 10848 id = 22 }
    name     = "11R"
    location = 220
    division =
    { id       = { type = 10848 id = 23 }
      name     = "5uBeuXJvetc"
      strength = 80
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 24 }
      name     = "179etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 25 }
      name     = "184etc"
      strength = 80
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 26 }
      name     = "33ux[XJvetc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 27 }
      name     = "2Ԏtc"
      strength = 80
      type     = light_armor
      model    = 0
    }
    division =
    { id       = { type = 10848 id = 28 }
      name     = "84@B/188etc" # 󂵂sB
      strength = 80
      type     = motorized
      extra    = engineer
    }
  }
  landunit =
  { id       = { type = 10848 id = 29 }
    name     = "27R"
    location = 272
    division =
    { id       = { type = 10848 id = 30 }
      name     = "180etc"
      strength = 100
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 31 }
      name     = "181etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 32 }
      name     = "182etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 33 }
      name     = "16uE[itXJvetc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 34 }
      name     = "3ueBz[LXJvetc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 35 }
      name     = "22uNXm_[XJvetc"
      strength = 80
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 36 }
    name     = "47Rc"
    location = 240
    division =
    { id       = { type = 10848 id = 37 }
      name     = "143etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 38 }
      name     = "121etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 39 }
      name     = "55etc"
      strength = 100
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 40 }
    name     = "17@BRc"
    location = 175
    division =
    { id       = { type = 10848 id = 41 }
      name     = "210ԉtc"
      strength = 60
      type     = motorized
      extra    = anti_tank
    }
  }
  landunit =
  { id       = { type = 10848 id = 42 }
    name     = "4R"
    location = 237
    division =
    { id       = { type = 10848 id = 43 }
      name     = "6uA[tXJvetc"
      strength = 100
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 44 }
      name     = "42etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 45 }
      name     = "49etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 46 }
      name     = "205ԉtc"
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
  }
  landunit =
  { id       = { type = 10848 id = 47 }
    name     = "3R"
    location = 238
    division =
    { id       = { type = 10848 id = 48 }
      name     = "27uI[XJvetc"
      strength = 100
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 49 }
      name     = "50u^}[XJvetc"
      strength = 100
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 50 }
      name     = "24uT}=EmtXJvetc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 51 }
      name     = "17uS[RtXJvetc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 52 }
      name     = "56u}XN@XJvetc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 53 }
      name     = "85etc"
      strength = 100
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 54 }
    name     = "10R"
    location = 236
    division =
    { id       = { type = 10848 id = 55 }
      name     = "86etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 56 }
      name     = "13u_QX^XJvetc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 57 }
      name     = "2ux[XJvetc"
      strength = 100
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 58 }
      name     = "113etc"
      strength = 80
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 59 }
      name     = "6u`KXJvRtc"
      strength = 80
      type     = cavalry
    }
    division =
    { id       = { type = 10848 id = 60 }
      name     = "115etc" # ̃_u
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 61 }
      name     = "4Ԏtc"
      strength = 80
      type     = light_armor
      model    = 0
    }
    division =
    { id       = { type = 10848 id = 62 }
      name     = "29ԉtc"
      strength = 80
      type     = motorized
    }
  }
  landunit =
  { id       = { type = 10848 id = 63 }
    name     = "13R"
    location = 234
    division =
    { id       = { type = 10848 id = 64 }
      name     = "161etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 65 }
      name     = "100etc"
      strength = 80
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 66 }
    name     = "31Rc"
    location = 253
    division =
    { id       = { type = 10848 id = 67 }
      name     = "193etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 68 }
      name     = "195etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 69 }
      name     = "200etc"
      strength = 100
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 70 }
    name     = "36Rc"
    location = 1848
    division =
    { id       = { type = 10848 id = 71 }
      name     = "140etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 72 }
      name     = "146etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 73 }
      name     = "228etc"
      strength = 100
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 74 }
    name     = "49Rc"
    location = 1850
    division =
    { id       = { type = 10848 id = 75 }
      name     = "199etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 76 }
      name     = "197uL[CFtXJvetc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 77 }
      name     = "190etc"
      strength = 100
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 78 }
    name     = "55Rc"
    location = 1857
    division =
    { id       = { type = 10848 id = 79 }
      name     = "189etc"
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 80 }
      name     = "169etc"
      strength = 70
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 81 }
      name     = "130etc"
      strength = 70
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 82 }
    name     = "15@BRc"
    location = 1370
    division =
    { id       = { type = 10848 id = 83 }
      name     = "212ԉtc"
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
  }
  landunit =
  { id       = { type = 10848 id = 84 }
    name     = "24@BRc"
    location = 1520
    division =
    { id       = { type = 10848 id = 85 }
      name     = "213ԉtc"
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
  }
  landunit =
  { id       = { type = 10848 id = 86 }
    name     = "5R"
    location = 1368
    division =
    { id       = { type = 10848 id = 87 }
      name     = "45uHXJvetc"
      strength = 80
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 88 }
      name     = "87etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 89 }
      name     = "62uĩٸЪƽǽԁvetc"
      strength = 80
      type     = infantry
      extra    = artillery
    }
  }
  landunit =
  { id       = { type = 10848 id = 90 }
    name     = "6R"
    location = 1372
    division =
    { id       = { type = 10848 id = 91 }
      name     = "159etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 92 }
      name     = "139etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 93 }
      name     = "141etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 94 }
      name     = "3uxbTuXJvRtc"
      strength = 80
      type     = cavalry
    }
    division =
    { id       = { type = 10848 id = 95 }
      name     = "81ԉtc"
      strength = 80
      type     = motorized
      extra    = anti_tank
    }
  }
  landunit =
  { id       = { type = 10848 id = 96 }
    name     = "12R"
    location = 258
    division =
    { id       = { type = 10848 id = 97 }
      name     = "164etc"
      strength = 100
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 98 }
      name     = "60etc"
      strength = 80
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10848 id = 99 }
      name     = "69etc"
      strength = 80
      type     = bergsjaeger
    }
  }
  landunit =
  { id       = { type = 10848 id = 100 }
    name     = "26R"
    location = 133
    division =
    { id       = { type = 10848 id = 101 }
      name     = "99etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 103 }
      name     = "173etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 102 }
      name     = "240/7ԉtc"
      strength = 60
      type     = motorized
    }
  }
  landunit =
  { id       = { type = 10848 id = 104 }
    name     = "7Rc"
    location = 260
    division =
    { id       = { type = 10848 id = 105 }
      name     = "116etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 107 }
      name     = "196uƪ۰̽ԁvetc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 106 }
      name     = "206etc"
      strength = 100
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 108 }
    name     = "9Rc"
    location = 247
    division =
    { id       = { type = 10848 id = 110 }
      name     = "106etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 111 }
      name     = "156etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 112 }
      name     = "47etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 109 }
      name     = "32Rtc"
      strength = 30
      type     = cavalry
    }
  }
  landunit =
  { id       = { type = 10848 id = 113 }
    name     = "9R"
    location = 243
    division =
    { id       = { type = 10848 id = 114 }
      name     = "176etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 115 }
      name     = "25etc"
      strength = 80
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 116 }
      name     = "74etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 117 }
      name     = "51etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 118 }
      name     = "95u_XJvetc"
      strength = 80
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10848 id = 119 }
      name     = "9uNB[XJvRtc"
      strength = 80
      type     = cavalry
    }
    division =
    { id       = { type = 10848 id = 120 }
      name     = "15ԉtc"
      strength = 80
      type     = motorized
    }
  }
  landunit =
  { id       = { type = 10848 id = 121 }
    name     = "gXR[JTXRǋ"
    location = 1907
    division =
    { id       = { type = 10848 id = 122 }
      name     = "136etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 123 }
      name     = "138etc"
      strength = 80
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10848 id = 124 }
      name     = "47etc"
      strength = 80
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10848 id = 125 }
      name     = "17uS[RtXJvetc"
      strength = 100
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10848 id = 126 }
      name     = "63etc"
      strength = 100
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10848 id = 127 }
      name     = "24Rtc"
      strength = 30
      type     = cavalry
    }
  }
  landunit =
  { id       = { type = 10848 id = 129 }
    name     = "28@BRc"
    location = 277
    division =
    { id       = { type = 10848 id = 128 }
      name     = "6Ԏtc"
      strength = 90
      type     = light_armor
      model    = 0
    }
  }
  landunit =
  { id       = { type = 10848 id = 130 }
    name     = "AnQXNRǋ"
    location = 153
    division =
    { id       = { type = 10848 id = 131 }
      name     = "88etc"
      strength = 80
      type     = infantry
      extra    = artillery
    }
  }
  landunit =
  { id       = { type = 10848 id = 132 }
    name     = "XNRǋ"
    location = 175
    division =
    { id       = { type = 10848 id = 133 }
      name     = "X^tJ"
      strength = 100
      type     = hq
    }
    division =
    { id       = { type = 10848 id = 134 }
      name     = "118etc"
      strength = 80
      type     = infantry
      extra    = engineer
    }
    division =
    { id       = { type = 10848 id = 135 }
      name     = "235etc"
      strength = 80
      type     = infantry
      extra    = engineer
    }
  }
  landunit =
  { id       = { type = 10848 id = 136 }
    name     = "kJtJ[XRǋ"
    location = 1845
    division =
    { id       = { type = 10848 id = 137 }
      name     = "157etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 138 }
      name     = "28etc"
      strength = 30
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10848 id = 139 }
      name     = "203ԉtc"
      strength = 60
      type     = motorized
    }
  }
  landunit =
  { id       = { type = 10848 id = 140 }
    name     = "I[Rǋ"
    location = 285
    division =
    { id       = { type = 10848 id = 144 }
      name     = "19u@[jFVJ[vetc"
      strength = 100
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 142 }
      name     = "89etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 143 }
      name     = "217etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 141 }
      name     = "120etc"
      strength = 100
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 147 }
    name     = "AWARǋ"
    location = 1556
    division =
    { id       = { type = 10848 id = 145 }
      name     = "68/83/194etc"
      strength = 100
      type     = bergsjaeger
    }
    division =
    { id       = { type = 10848 id = 146 }
      name     = "21usF[XJvetc"
      strength = 100
      type     = bergsjaeger
    }
  }
  landunit =
  { id       = { type = 10848 id = 149 }
    name     = "gXoCJRǋ"
    location = 1520
    division =
    { id       = { type = 10848 id = 150 }
      name     = "65etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 148 }
      name     = "114etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 151 }
      name     = "93uޫİ=ްؽԁvetc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 152 }
      name     = "94etc"
      strength = 80
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 10848 id = 153 }
    name     = "17R"
    location = 1907
    division =
    { id       = { type = 10848 id = 154 }
      name     = "82ԉtc"
      strength = 100
      type     = motorized
      extra    = anti_tank
    }
  }
  landunit =
  { id       = { type = 10848 id = 155 }
    name     = "1R"
    location = 1383
    division =
    { id       = { type = 10848 id = 156 }
      name     = "39etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 157 }
      name     = "26uYgE[XgtXJvetc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 158 }
      name     = "21usF[XJvetc"
      strength = 100
      type     = infantry
      extra    = artillery
    }
  }
  landunit =
  { id       = { type = 10848 id = 159 }
    name     = "21R"
    location = 1528
    division =
    { id       = { type = 10848 id = 160 }
      name     = "59etc"
      strength = 80
      type     = infantry
      extra    = artillery
    }
    division =
    { id       = { type = 10848 id = 161 }
      name     = "22uNXm_[XJvetc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 162 }
      name     = "1etc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 163 }
      name     = "4uX}F[XJvetc"
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 164 }
      name     = "117etc" # ̃_u
      strength = 100
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 165 }
      name     = "239ԉtc"
      strength = 30
      type     = motorized
      extra    = anti_tank
    }
  }
  landunit =
  { id       = { type = 10848 id = 166 }
    name     = "ɓꕔ"
    location = 1523
    division =
    { id       = { type = 10848 id = 167 }
      name     = "35uXBr[XJvetc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 168 }
      name     = "66etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 169 }
      name     = "101etc"
      strength = 30
      type     = bergsjaeger
    }
  }
  landunit =
  { id       = { type = 10848 id = 170 }
    name     = "2R"
    location = 1827
    division =
    { id       = { type = 10848 id = 171 }
      name     = "12etc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 172 }
      name     = "119etc" # ̃_u
      strength = 80
      type     = infantry
      extra    = artillery
    }
  }
  landunit =
  { id       = { type = 10848 id = 173 }
    name     = "25R"
    location = 1570
    division =
    { id            = { type = 10848 id = 174 }
      name          = "92etc"
      strength      = 80
      type          = infantry
      extra         = artillery
      brigade_model = 2
    }
    division =
    { id       = { type = 10848 id = 175 }
      name     = "32uT[^tXJvetc"
      strength = 80
      type     = infantry
    }
    division =
    { id       = { type = 10848 id = 176 }
      name     = "40u{O`XJvetc"
      strength = 80
      type     = infantry
    }
  }
  # ################################
	### Soviet Navy OOB ###
  # ################################
  navalunit =
  { id       = { type = 10848 id = 177 }
    name     = "km͑" # Arskoje  kmB󂹂Ă܂B
    location = 133 # Murmansk
    base     = 133
    division =
    { id    = { type = 10848 id = 178 }
      name  = "1쒀Q"
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 10848 id = 179 }
      name  = "1Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10848 id = 180 }
      name  = "2Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10848 id = 181 }
      name  = "18Q"
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10848 id = 182 }
      name  = "19Q"
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10848 id = 183 }
      name  = "20Q"
      type  = submarine
      model = 0
    }
  }
  navalunit =
  { id       = { type = 10848 id = 184 }
    name     = "CCCP og͑"
    location = 187 # Leningrad
    base     = 187
    division =
    { id    = { type = 10848 id = 185 }
      name  = "}[g"
      type  = battleship
      model = 0
      extra1 = naval_sa_l
      extra2 = naval_anti_air_l
      extra3 = none
      extra4 = none
      extra5 = none
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
      brigade_model4 = 0
      brigade_model5 = 0
    }
    division =
    { id    = { type = 10848 id = 186 }
      name  = "ؽԥڳޫح¨"
      type  = battleship
      model = 0
      extra1 = naval_sa_l
      extra2 = naval_anti_air_l
      extra3 = none
      extra4 = none
      extra5 = none
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
      brigade_model4 = 0
      brigade_model5 = 0
    }
    division =
    { id    = { type = 10848 id = 187 }
      name  = "4쒀Q"
      type  = destroyer
      model = 1
    }
    division =
    { id    = { type = 10848 id = 188 }
      name  = "3Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10848 id = 189 }
      name  = "4Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10848 id = 190 }
      name  = "5Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10848 id = 191 }
      name  = "6Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10848 id = 192 }
      name  = "7Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 10848 id = 193 }
      name  = "21Q"
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10848 id = 194 }
      name  = "22Q"
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10848 id = 195 }
      name  = "23Q"
      type  = submarine
      model = 0
    }
  }
  navalunit =
  { id       = { type = 10848 id = 196 }
    name     = "C͑"
    location = 253 # Sevastopol
    base     = 253
    division =
    { id    = { type = 10848 id = 197 }
      name  = "pWXJERi"
      type  = battleship
      model = 0
      extra1 = naval_sa_l
      extra2 = naval_anti_air_l
      extra3 = none
      extra4 = none
      extra5 = none
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
      brigade_model4 = 0
      brigade_model5 = 0
    }
    division =
    { id    = { type = 10848 id = 198 }
      name  = "NXjBEJtJX"
      type  = heavy_cruiser
      model = 0
      extra1 = naval_sa_l
      extra2 = naval_anti_air_l
      extra3 = none
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 10848 id = 200 }
      name  = "vtBe"
      type  = light_cruiser
      model = 0
      extra1 = naval_anti_air_s
      extra2 = none
      brigade_model1 = 0
      brigade_model2 = 0
    }
    division =
    { id    = { type = 10848 id = 201 }
      name  = "p[~bgN"
      type  = light_cruiser
      model = 0
      extra1 = naval_anti_air_s
      extra2 = none
      brigade_model1 = 0
      brigade_model2 = 0
    }
    division =
    { id    = { type = 10848 id = 202 }
      name  = "`FH[iEENC[i"
      type  = light_cruiser
      model = 0
      extra1 = naval_anti_air_s
      extra2 = none
      brigade_model1 = 0
      brigade_model2 = 0
    }
    division =
    { id    = { type = 10848 id = 203 }
      name  = "5쒀Q"
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 10848 id = 204 }
      name  = "11Q"
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10848 id = 205 }
      name  = "24Q"
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10848 id = 206 }
      name  = "25Q"
      type  = submarine
      model = 0
    }
  }
  navalunit =
  { id       = { type = 10848 id = 207 }
    name     = "x[O͑"
    location = 1372 # Vladivostok
    base     = 1372
    division =
    { id    = { type = 10848 id = 208 }
      name  = "7쒀Q"
      type  = destroyer
      model = 0
    }
    division =
    { id    = { type = 10848 id = 209 }
      name  = "12Q"
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10848 id = 210 }
      name  = "13Q"
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10848 id = 211 }
      name  = "14Q"
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 10848 id = 212 }
      name  = "17Q"
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 10848 id = 213 }
      name  = "26Q"
      type  = submarine
      model = 0
    }
    division =
    { id   = { type = 10848 id = 199 }
      name = "1AQ"
      type = transport
    }
  }
	### USSR Air OOB ###
  airunit =
  { id       = { type = 10848 id = 215 }
    name     = "jO[hIqtc"
    location = 187
    base     = 187
    division =
    { id       = { type = 10848 id = 216 }
      name     = "1퓬qtc"
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 10848 id = 217 }
      name     = "2퓬qtc"
      strength = 100
      type     = interceptor
      model    = 0
    }
  }
  airunit =
  { id       = { type = 10848 id = 218 }
    name     = "[KIIqtc"
    location = 201
    base     = 201
    division =
    { id       = { type = 10848 id = 219 }
      name     = "4퓬qtc"
      strength = 100
      type     = interceptor
      model    = 0
    }
  }
  airunit =
  { id       = { type = 10848 id = 220 }
    name     = "IIIqtc"
    location = 220
    base     = 220
    division =
    { id       = { type = 10848 id = 221 }
      name     = "12qtc"
      strength = 100
      type     = tactical_bomber
      model    = 0
    }
    division =
    { id       = { type = 10848 id = 222 }
      name     = "13qtc"
      strength = 100
      type     = tactical_bomber
      model    = 0
    }
    division =
    { id       = { type = 10848 id = 223 }
      name     = "9퓬qtc"
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 10848 id = 224 }
      name     = "10퓬qtc"
      strength = 100
      type     = interceptor
      model    = 0
    }
  }
  airunit =
  { id       = { type = 10848 id = 225 }
    name     = "LGtIVqtc"
    location = 238
    base     = 238
    division =
    { id       = { type = 10848 id = 226 }
      name     = "14퓬qtc"
      strength = 100
      type     = interceptor
      model    = 0
    }
  }
  airunit =
  { id       = { type = 10848 id = 227 }
    name     = "XNVqtc"
    location = 175
    base     = 175
    division =
    { id       = { type = 10848 id = 228 }
      name     = "6퓬qtc"
      strength = 100
      type     = interceptor
      model    = 0
    }
  }
  airunit =
  { id       = { type = 10848 id = 229 }
    name     = "gXoCJVIqtc"
    location = 1372
    base     = 1372
    division =
    { id       = { type = 10848 id = 230 }
      name     = "30qtc"
      strength = 100
      type     = tactical_bomber
      model    = 0
    }
  }
  airunit =
  { id       = { type = 10848 id = 231 }
    name     = "J`cJVIIqtc"
    location = 1525
    base     = 1525
    division =
    { id       = { type = 10848 id = 232 }
      name     = "29퓬qtc"
      strength = 100
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 10848 id = 214 }
      name     = "33qtc"
      strength = 100
      type     = tactical_bomber
      model    = 0
    }
  }
	### Development ###
  division_development =
  { name  = "8쒀Q"
    type  = destroyer
    model = 1
    cost  = 2
    id    = { type = 10848 id = 233 }
    date  = { year = 1936 month = april day = 1 }
  }
  division_development =
  { name  = "29Q"
    type  = submarine
    model = 1
    cost  = 1.9
    id    = { type = 10848 id = 234 }
    date  = { year = 1936 month = february day = 1 }
  }
  division_development =
  { name  = "30Q"
    type  = submarine
    model = 1
    cost  = 1.9
    id    = { type = 10848 id = 235 }
    date  = { year = 1936 month = march day = 1 }
  }
}
