
##############################
# Country definition for FRA #
##############################

province =
{ id         = 32
  ic         = 1
  anti_air   = { size = 4 current_size = 4 }
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Brest
province = { id = 35 anti_air = { size = 2 current_size = 2 } } # Nantes
province =
{ id         = 38
  anti_air   = { size = 3 current_size = 3 }
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 6 current_size = 6 }
}              # Cherbourg
province = { id = 39 anti_air = { size = 1 current_size = 1 } } # Caen
province =
{ id         = 43
  naval_base = { size = 3 current_size = 3 }
}              # Dunkerque
province =
{ id       = 44
  air_base = { size = 10 current_size = 10 }
  anti_air = { size = 1 current_size = 1 }
}            # Lille
province =
{ id       = 56
  ic       = 1
  anti_air = { size = 5 current_size = 5 }
  air_base = { size = 10 current_size = 10 }
}            # Paris
province =
{ id       = 59
  air_base = { size = 10 current_size = 10 }
}            # Cholet
province =
{ id       = 62
  air_base = { size = 10 current_size = 10 }
}            # Auxerre
province =
{ id       = 72
  anti_air = { size = 3 current_size = 3 }
  air_base = { size = 10 current_size = 10 }
  landfort = { size = 10 current_size = 10 }
}            # Metz
province = { id = 73 anti_air = { size = 2 current_size = 2 } landfort = { size = 10 current_size = 10 } } # Strasbourg
province = { id = 316 anti_air = { size = 2 current_size = 2 } landfort = { size = 10 current_size = 10 } } # Mulhouse
province = { id = 317 anti_air = { size = 1 current_size = 1 } } # Chaumont
province = { id = 320 ic = 1 anti_air = { size = 1 current_size = 1 } } # Vichy
province =
{ id         = 325
  anti_air   = { size = 4 current_size = 4 }
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 6 current_size = 6 }
}              # Bordeaux
province =
{ id       = 359
  air_base = { size = 10 current_size = 10 }
}            # Toulouse
province =
{ id         = 364
  ic         = 1
  anti_air   = { size = 5 current_size = 5 }
  air_base   = { size = 10 current_size = 10 }
  naval_base = { size = 10 current_size = 10 }
}              # Marseille
province = { id = 366 landfort = { size = 5 current_size = 5 } } # Nice
province = { id = 527 landfort = { size = 3 current_size = 3 } } # Grenoble
province = { id = 528 ic = 1 } # Lyon
province = { id = 875 supplypool = 1 } # Cayenne
province =
{ id         = 939
  anti_air   = { size = 4 current_size = 4 }
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 5 current_size = 5 }
}              # Tunis
province =
{ id         = 949
  supplypool = 500
  oilpool    = 1
  anti_air   = { size = 4 current_size = 4 }
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 5 current_size = 5 }
}              # Algiers
province =
{ id         = 953
  anti_air   = { size = 2 current_size = 2 }
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
}              # Oran
province =
{ id         = 958
  anti_air   = { size = 3 current_size = 3 }
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 4 current_size = 4 }
}              # Casablanca
province =
{ id         = 981
  anti_air   = { size = 3 current_size = 3 }
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
}              # Dakar
province =
{ id       = 993
  anti_air = { size = 2 current_size = 2 }
  air_base = { size = 4 current_size = 4 }
}            # Abidjan
province = { id = 1037 supplypool = 1 } # Djibouti
province =
{ id         = 1328
  anti_air   = { size = 4 current_size = 4 }
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 4 current_size = 4 }
}              # Hanoi
province =
{ id         = 1337
  supplypool = 100
  oilpool    = 1
  anti_air   = { size = 3 current_size = 3 }
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 4 current_size = 4 }
}              # Saigon
province =
{ id         = 1794
  anti_air   = { size = 2 current_size = 2 }
  air_base   = { size = 4 current_size = 4 }
  naval_base = { size = 2 current_size = 2 }
}              # Beirut

#####################
# Country main data #
#####################

country =
{ tag                    = FRA
  capital                = 56
  # Resource Reserves
  energy                 = 1000
  metal                  = 1000
  rare_materials         = 500
  oil                    = 500
  supplies               = 500
  money                  = 50
  manpower               = 325
  transports             = 300
  escorts                = 60
  peacetime_ic_mod       = 0.5
  diplomacy =
  { relation = { tag = AST value = 150 }
    relation = { tag = AUS value = -10 }
    relation =
    { tag        = BEL
      value      = 120
      guaranteed = { day = 7 month = january year = 1935 }
    }
    relation = { tag = BHU value = 150 }
    relation = { tag = BUL value = 20 }
    relation = { tag = CAN value = 150 }
    relation = { tag = CZE value = 150 }
    relation = { tag = ENG value = 150 }
    relation = { tag = EST value = 65 }
    relation = { tag = ETH value = 25 }
    relation = { tag = FIN value = 85 }
    relation = { tag = GER value = -35 }
    relation = { tag = GRE value = 20 }
    relation =
    { tag        = HOL
      value      = 75
      guaranteed = { day = 7 month = january year = 1935 }
    }
    relation = { tag = HUN value = -70 }
    relation = { tag = IRE value = 25 }
    relation = { tag = IRQ value = 100 }
    relation = { tag = ITA value = -50 }
    relation = { tag = JAP value = -20 }
    relation = { tag = LAT value = 65 }
    relation = { tag = LIT value = 65 }
    relation =
    { tag        = LUX
      value      = 120
      guaranteed = { day = 7 month = january year = 1935 }
    }
    relation = { tag = NEP value = 150 }
    relation =
    { tag        = NOR
      guaranteed = { day = 30 month = august year = 1934 }
    }
    relation = { tag = NZL value = 150 }
    relation = { tag = OMN value = 150 }
    relation =
    { tag        = POL
      value      = 100
      guaranteed = { day = 7 month = january year = 1935 }
    }
    relation = { tag = ROM value = 50 }
    relation = { tag = SAF value = 150 }
    relation = { tag = SAU value = 10 }
    relation =
    { tag        = SCH
      value      = 1
      guaranteed = { day = 16 month = may year = 1935 }
    }
    relation = { tag = SIA value = -100 }
    relation = { tag = SOV value = 100 }
    relation = { tag = SPR value = 10 }
    relation =
    { tag        = TUR
      value      = 50
      guaranteed = { day = 7 month = january year = 1935 }
    }
    relation = { tag = USA value = 65 }
    relation = { tag = YEM value = 150 }
    relation =
    { tag        = YUG
      value      = 50
      guaranteed = { day = 7 month = january year = 1935 }
    }
  }
  SpyInfo                = { country = "FRA" NumberOfSpies = 5 }
  SpyInfo                = { country = "ENG" NumberOfSpies = 3 }
  SpyInfo                = { country = "GER" NumberOfSpies = 4 }
  SpyInfo                = { country = "SOV" NumberOfSpies = 2 }
  SpyInfo                = { country = "CZE" NumberOfSpies = 1 }
  SpyInfo                = { country = "AUS" NumberOfSpies = 1 }
  SpyInfo                = { country = "SPR" NumberOfSpies = 4 }
  SpyInfo                = { country = "POL" NumberOfSpies = 2 }
  SpyInfo                = { country = "SWE" NumberOfSpies = 3 }
  SpyInfo                = { country = "NOR" NumberOfSpies = 1 }
  SpyInfo                = { country = "FIN" NumberOfSpies = 1 }
  SpyInfo                = { country = "YUG" NumberOfSpies = 1 }
  SpyInfo                = { country = "HUN" NumberOfSpies = 2 }
  SpyInfo                = { country = "BUL" NumberOfSpies = 1 }
  SpyInfo                = { country = "BEL" NumberOfSpies = 4 }
  SpyInfo                = { country = "DEN" NumberOfSpies = 2 }
  SpyInfo                = { country = "HOL" NumberOfSpies = 3 }
  SpyInfo                = { country = "ARG" NumberOfSpies = 3 }
  SpyInfo                = { country = "USA" NumberOfSpies = 2 }
  SpyInfo                = { country = "ALB" NumberOfSpies = 1 }
  SpyInfo                = { country = "GRE" NumberOfSpies = 1 }
  SpyInfo                = { country = "JAP" NumberOfSpies = 2 }
  SpyInfo                = { country = "ROM" NumberOfSpies = 2 }
  SpyInfo                = { country = "LUX" NumberOfSpies = 2 }
  SpyInfo                = { country = "POR" NumberOfSpies = 1 }
  SpyInfo                = { country = "ITA" NumberOfSpies = 4 }
  # Togoland
  # Metropolitan France
  nationalprovinces      = { 529 527 366 365 367 364 363 362 358 328 327 326 325 324 359 361 319 360 322 323 59  60  61  62  63  318 317 316 73  72 
                             64  53  44  43  18  54  42  55  41  56  57  58  32  33  34  35  36  37  38  39  40  320 321 528
                           }
  # Metropolitan France
  ownedprovinces         = { 529  527  366  365  367  364  363  362  358  328  327  326  325  324  359  361  319  360  322  323  59   60   61   62  
                             63   318  317  316  73   72   64   53   44   43   18   54   42   55   41   56   57   58   32   33   34   35   36   37  
                             38   39   40   320  321  528  875  898  899  956  969  968  959  958  960  966  1014 970  1013 943  942  945  944  946 
                             947  949  948  951  950  952  953  935  934  936  938  937  939  940  941  1862 1861 1863 1792 1793 1794 1795 1037 973 
                             974  975  1083 1084 998  976  977  978  981  984  987  989  990  985  980  986  979  994  996  997  1005 1006 991  995 
                             993  1088 1082 1081 1080 1079 1086 1070 1078 1077 1087 1089 1092 1093 1075 1076 1134 1137 1135 1338 1339 1340 1337 1335
                             1336 1334 1333 1332 1341 1329 1328 1306 1326 1692 1691 1687 1690 1689 1688 1751 1003 1004
                           }
  # Togoland
  # Metropolitan France
  controlledprovinces    = { 529  527  366  365  367  364  363  362  358  328  327  326  325  324  359  361  319  360  322  323  59   60   61   62  
                             63   318  317  316  73   72   64   53   44   43   18   54   42   55   41   56   57   58   32   33   34   35   36   37  
                             38   39   40   320  321  528  875  898  899  956  969  968  959  958  960  966  1014 970  1013 943  942  945  944  946 
                             947  949  948  951  950  952  953  935  934  936  938  937  939  940  941  1862 1861 1863 1792 1793 1794 1795 1037 973 
                             974  975  1083 1084 998  976  977  978  981  984  987  989  990  985  980  986  979  994  996  997  1005 1006 991  995 
                             993  1088 1082 1081 1080 1079 1086 1070 1078 1077 1087 1089 1092 1093 1075 1076 1134 1137 1135 1338 1339 1340 1337 1335
                             1336 1334 1333 1332 1341 1329 1328 1306 1326 1692 1691 1687 1690 1689 1688 1751 1003 1004
                           }
  # FRA 1936 techs
  # ######################
  techapps               = { 4010  4020  4120  4130  2150  2010  2020  2030  2290  2300  2310  2040  2450  2460  2510  1010  1020  1190  1200  1110 
                             2400  1310  5010  5020  5050  5080  5090  5190  5200  5310  5320  5470  5480  9010  9020  9030  9040  6010  6030  6110 
                             6120  8010  8020  8030  8040  8050  8070  8100  3010  3020  3030  3070  3080  3090  3100  3130  3140  3150  3190  3200 
                             3210  3220  3250  3260  3270  3280  3320  3330  3400  3410  3420  14000
                           }
  policy =
  { date              = { year = 0 month = january day = 0 }
    democratic        = 10
    political_left    = 6
    free_market       = 8
    freedom           = 10
    professional_army = 3
    defense_lobby     = 7
    interventionism   = 5
  }
  headofstate            = { type = 9 id = 2001 }
  headofgovernment       = { type = 9 id = 2002 }
  foreignminister        = { type = 9 id = 2003 }
  armamentminister       = { type = 9 id = 2004 }
  ministerofsecurity     = { type = 9 id = 2005 }
  ministerofintelligence = { type = 9 id = 2006 }
  chiefofstaff           = { type = 9 id = 2007 }
  chiefofarmy            = { type = 9 id = 2008 }
  chiefofnavy            = { type = 9 id = 2009 }
  chiefofair             = { type = 9 id = 2010 }

  nationalidentity = "policy_identity_conciliatory" 
	socialpolicy = "policy_social_liberal"
	nationalculture = "policy_culture_civic"

  # #################
  # ###FRENCH OOB####
  # #################
  landunit =
  { id       = { type = 13500 id = 1 }
    name     = "7R"
    location = 55
    division =
    { id    = { type = 13500 id = 2 }
      name  = "4tc"
      type  = infantry
      extra = artillery
    }
    division =
    { id   = { type = 13500 id = 3 }
      name = "60tc"
      type = infantry
    }
    division =
    { id    = { type = 13500 id = 4 }
      name  = "41\@btc"
      type  = light_armor
      model = 1
    }
    division =
    { id       = { type = 13500 id = 5 }
      name     = "25ԉtc"
      strength = 70
      type     = infantry
      model    = 1
      extra    = armored_car
    }
  }
  landunit =
  { id       = { type = 13500 id = 6 }
    name     = "1R"
    location = 63
    division =
    { id    = { type = 13500 id = 7 }
      name  = "1y@Btc"
      type  = infantry
      model = 1
      extra = armored_car
    }
    division =
    { id    = { type = 13500 id = 8 }
      name  = "1tc"
      type  = infantry
      extra = anti_tank
    }
    division =
    { id    = { type = 13500 id = 9 }
      name  = "2\@btc"
      type  = light_armor
      model = 1
    }
    division =
    { id    = { type = 13500 id = 10 }
      name  = "12ԉtc"
      type  = infantry
      model = 1
      extra = armored_car
    }
    division =
    { id    = { type = 13500 id = 11 }
      name  = "2kAtJtc"
      type  = infantry
      extra = anti_tank
    }
  }
  landunit =
  { id       = { type = 13500 id = 12 }
    name     = "AvXR"
    location = 527
    division =
    { id   = { type = 13500 id = 13 }
      name = "65Rxtc"
      type = bergsjaeger
    }
    division =
    { id   = { type = 13500 id = 14 }
      name = "64Rxtc"
      type = bergsjaeger
    }
  }
  landunit =
  { id       = { type = 13500 id = 15 }
    name     = "XIXRǋ"
    location = 949
    division =
    { id   = { type = 13500 id = 16 }
      name = "85AtJtc"
      type = infantry
    }
    division =
    { id       = { type = 13500 id = 17 }
      name     = "182AtJtc"
      strength = 60
      type     = infantry
    }
  }
  landunit =
  { id       = { type = 13500 id = 18 }
    name     = "bR"
    location = 959
    division =
    { id       = { type = 13500 id = 19 }
      name     = "3bRtc"
      strength = 60
      type     = infantry
      extra    = anti_tank
    }
  }
  landunit =
  { id       = { type = 13500 id = 20 }
    name     = "9R"
    location = 64
    division =
    { id   = { type = 13500 id = 21 }
      name = "4tc"
      type = infantry
    }
    division =
    { id    = { type = 13500 id = 22 }
      name  = "1yRtc"
      type  = cavalry
      model = 1
    }
    division =
    { id       = { type = 13500 id = 23 }
      name     = "1ԉtc"
      strength = 70
      type     = infantry
      model    = 1
      extra    = armored_car
    }
    division =
    { id    = { type = 13500 id = 24 }
      name  = "18tc"
      type  = infantry
      extra = anti_air
    }
  }
  landunit =
  { id       = { type = 13500 id = 25 }
    name     = "2R"
    location = 72
    division =
    { id   = { type = 13500 id = 26 }
      name = "2yRtc"
      type = cavalry
    }
    division =
    { id    = { type = 13500 id = 27 }
      name  = "71tc"
      type  = infantry
      extra = anti_tank
    }
    division =
    { id       = { type = 13500 id = 28 }
      name     = "41tc"
      strength = 70
      type     = infantry
    }
    division =
    { id   = { type = 13500 id = 29 }
      name = "1Antc"
      type = infantry
    }
  }
  landunit =
  { id       = { type = 13500 id = 30 }
    name     = "`jWAR"
    location = 939
    division =
    { id       = { type = 14000 id = 31 }
      name     = "AtJRiߕ"
      type     = hq
      model    = 0
      strength = 100
    }
    division =
    { id       = { type = 13500 id = 32 }
      name     = "83AtJtc"
      strength = 100
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id   = { type = 13500 id = 33 }
      name = "81AtJtc"
      type = infantry
    }
    division =
    { id       = { type = 13500 id = 34 }
      name     = "6yRtc"
      strength = 65
      type     = cavalry
    }
  }
  landunit =
  { id       = { type = 13500 id = 35 }
    name     = "3R"
    location = 53
    division =
    { id       = { type = 13500 id = 36 }
      name     = "3yRtc"
      strength = 75
      type     = cavalry
    }
    division =
    { id   = { type = 13500 id = 37 }
      name = "6tc"
      type = infantry
    }
    division =
    { id   = { type = 13500 id = 38 }
      name = "8tc"
      type = infantry
    }
    division =
    { id    = { type = 13500 id = 39 }
      name  = "3kAtJtc"
      type  = infantry
      extra = anti_tank
    }
    division =
    { id   = { type = 13500 id = 40 }
      name = "26tc"
      type = infantry
    }
    division =
    { id   = { type = 13500 id = 41 }
      name = "42tc"
      type = infantry
    }
    division =
    { id    = { type = 13500 id = 42 }
      name  = "20tc"
      type  = infantry
      extra = artillery
    }
  }
  landunit =
  { id       = { type = 13500 id = 43 }
    name     = "ChViRc"
    location = 1337
    division =
    { id       = { type = 13500 id = 44 }
      name     = "gLtc"
      strength = 65
      type     = infantry
    }
    division =
    { id       = { type = 13500 id = 45 }
      name     = "R[`Vi=J{WAtc"
      strength = 60
      type     = infantry
      extra    = engineer
    }
  }
  landunit =
  { id       = { type = 13500 id = 46 }
    name     = "R"
    location = 1037
    division =
    { id       = { type = 13500 id = 47 }
      name     = "1y"
      strength = 100
      type     = infantry
      model    = 1
    }
    division =
    { id       = { type = 13500 id = 48 }
      name     = "1/2Ay"
      strength = 100
      type     = bergsjaeger
    }
  }
  landunit =
  { id       = { type = 13500 id = 49 }
    name     = "4R"
    location = 316
    division =
    { id       = { type = 13500 id = 50 }
      name     = "11tc"
      strength = 70
      type     = infantry
    }
    division =
    { id   = { type = 13500 id = 51 }
      name = "45tc"
      type = infantry
    }
    division =
    { id    = { type = 13500 id = 52 }
      name  = "52AtJtc"
      type  = infantry
      extra = artillery
    }
  }
  landunit =
  { id       = { type = 13500 id = 53 }
    name     = "5R"
    location = 366
    division =
    { id       = { type = 13500 id = 54 }
      name     = "24tc"
      strength = 70
      type     = infantry
    }
    division =
    { id   = { type = 13500 id = 55 }
      name = "31Rxtc"
      type = bergsjaeger
    }
    division =
    { id    = { type = 13500 id = 56 }
      name  = "70tc"
      type  = infantry
      extra = anti_tank
    }
    division =
    { id    = { type = 13500 id = 57 }
      name  = "30tc"
      type  = infantry
      extra = anti_tank
    }
  }
  landunit =
  { id       = { type = 13500 id = 58 }
    name     = "8R"
    location = 73
    division =
    { id       = { type = 13500 id = 60 }
      name     = "}Wmiߕ"
      type     = hq
      model    = 0
      strength = 100
    }
    division =
    { id       = { type = 13500 id = 61 }
      name     = "13tc"
      strength = 70
      type     = infantry
      extra    = anti_tank
    }
    division =
    { id       = { type = 13500 id = 62 }
      name     = "19tc"
      strength = 70
      type     = infantry
    }
    division =
    { id   = { type = 13500 id = 59 }
      name = "54tc"
      type = infantry
    }
  }
  # ######################################
  # ####### France Navy OOB ##############
  # ######################################
  navalunit =
  { id       = { type = 13500 id = 63 }
    name     = "tX1͑"
    location = 32
    base     = 32
    division =
    { id            = { type = 13500 id = 64 }
      name          = "xA"
      type          = carrier
      model         = 1
      extra         = cag
      brigade_model = 1
    }
    division =
    { id    = { type = 13500 id = 65 }
      name  = "AWF["
      type  = heavy_cruiser
      model = 2
      extra1 = naval_anti_air_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
    }
    division =
    { id    = { type = 13500 id = 66 }
      name  = "vQ"
      type  = light_cruiser
      model = 1
      extra1 = naval_anti_air_s
      extra2 = naval_spotter_s
      brigade_model1 = 0
      brigade_model2 = 1
    }
    division =
    { id    = { type = 13500 id = 67 }
      name  = "fQC=g[A"
      type  = light_cruiser
      model = 1
      extra1 = naval_anti_air_s
      extra2 = naval_spotter_s
      brigade_model1 = 0
      brigade_model2 = 1
    }
    division =
    { id    = { type = 13500 id = 68 }
      name  = "bg=sP"
      type  = light_cruiser
      model = 1
      extra1 = naval_anti_air_s
      extra2 = naval_spotter_s
      brigade_model1 = 0
      brigade_model2 = 1
    }
    division =
    { id    = { type = 13500 id = 69 }
      name  = "EK\jG["
      type  = light_cruiser
      model = 3
      extra1 = naval_anti_air_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 1
    }
    division =
    { id    = { type = 13500 id = 70 }
      name  = "1쒀Q"
      type  = destroyer
      model = 1
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
    division =
    { id    = { type = 13500 id = 71 }
      name  = "2쒀Q"
      type  = destroyer
      model = 0
      extra1 = naval_fire_controll_s
      brigade_model1 = 0
    }
    division =
    { id    = { type = 13500 id = 72 }
      name  = "3쒀Q"
      type  = destroyer
      model = 0
      extra1 = naval_fire_controll_s
      brigade_model1 = 0
    }
  }
  navalunit =
  { id       = { type = 13500 id = 73 }
    name     = "tX2͑"
    location = 364
    base     = 364
    division =
    { id    = { type = 13500 id = 74 }
      name  = "N[x"
      type  = battleship
      model = 0
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = none
      extra4 = none
      extra5 = none
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
      brigade_model4 = 0
      brigade_model5 = 0
    }
    division =
    { id    = { type = 13500 id = 75 }
      name  = "p"
      type  = battleship
      model = 0
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = none
      extra4 = none
      extra5 = none
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
      brigade_model4 = 0
      brigade_model5 = 0
    }
    division =
    { id    = { type = 13500 id = 76 }
      name  = "Vt"
      type  = heavy_cruiser
      model = 1
      extra1 = naval_anti_air_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
    }
    division =
    { id    = { type = 13500 id = 77 }
      name  = "fP[k"
      type  = heavy_cruiser
      model = 1
      extra1 = naval_anti_air_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 13500 id = 78 }
      name  = "vg"
      type  = light_cruiser
      model = 0
      extra1 = naval_anti_air_s
      extra2 = naval_fire_controll_s
      brigade_model1 = 0
      brigade_model2 = 1
    }
    division =
    { id    = { type = 13500 id = 79 }
      name  = "WkE_N"
      type  = light_cruiser
      model = 1
      extra1 = naval_anti_air_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 1
    }
    division =
    { id    = { type = 13500 id = 80 }
      name  = "4쒀Q"
      type  = destroyer
      model = 1
      extra1 = naval_fire_controll_s
      brigade_model1 = 0
    }
    division =
    { id    = { type = 13500 id = 81 }
      name  = "5쒀Q"
      type  = destroyer
      model = 1
      extra1 = naval_fire_controll_s
      brigade_model1 = 0
    }
    division =
    { id    = { type = 13500 id = 82 }
      name  = "6쒀Q"
      type  = destroyer
      model = 0
      extra1 = naval_fire_controll_s
      brigade_model1 = 0
    }
  }
  navalunit =
  { id       = { type = 13500 id = 83 }
    name     = "tX3͑"
    location = 949
    base     = 949
    division =
    { id    = { type = 13500 id = 84 }
      name  = "IZA"
      type  = battleship
      model = 0
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = none
      extra4 = none
      extra5 = none
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
      brigade_model4 = 0
      brigade_model5 = 0
    }         # Renamed from Jean Bart 1936
    division =
    { id    = { type = 13500 id = 85 }
      name  = "u^[j"
      type  = battleship
      model = 1
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = naval_anti_air_l
      extra4 = none
      extra5 = none
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
      brigade_model4 = 0
      brigade_model5 = 0
    }
    division =
    { id    = { type = 13500 id = 86 }
      name  = "tHbV"
      type  = heavy_cruiser
      model = 1
      extra1 = naval_anti_air_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
    }
    division =
    { id    = { type = 13500 id = 87 }
      name  = "gD[B"
      type  = heavy_cruiser
      model = 1
      extra1 = naval_anti_air_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 13500 id = 88 }
      name  = "7쒀Q"
      type  = destroyer
      model = 2
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
    division =
    { id    = { type = 13500 id = 89 }
      name  = "8쒀Q"
      type  = destroyer
      model = 2
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
    division =
    { id    = { type = 13500 id = 90 }
      name  = "9쒀Q"
      type  = destroyer
      model = 2
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
    division =
    { id    = { type = 13500 id = 91 }
      name  = "10쒀Q"
      type  = destroyer
      model = 2
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
  }
  navalunit =
  { id       = { type = 13500 id = 92 }
    name     = "tX4͑"
    location = 32
    base     = 32
    division =
    { id    = { type = 13500 id = 93 }
      name  = "[k"
      type  = battleship
      model = 1
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      extra4 = naval_anti_air_l
      extra5 = none
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
      brigade_model4 = 1
      brigade_model5 = 0
    }
    division =
    { id    = { type = 13500 id = 94 }
      name  = "v@X"
      type  = battleship
      model = 1
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = naval_anti_air_l
      extra4 = none
      extra5 = none
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
      brigade_model4 = 0
      brigade_model5 = 0
    }
    division =
    { id    = { type = 13500 id = 95 }
      name  = "Rx["
      type  = heavy_cruiser
      model = 1
      extra1 = naval_anti_air_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
    }
    division =
    { id    = { type = 13500 id = 96 }
      name  = "fvNX"
      type  = heavy_cruiser
      model = 1
      extra1 = naval_anti_air_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
    }
    division =
    { id    = { type = 13500 id = 97 }
      name  = "G~[Ex^"
      type  = light_cruiser
      model = 2
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 1
    }
    division =
    { id    = { type = 13500 id = 98 }
      name  = "11쒀Q"
      type  = destroyer
      model = 1
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
  }
  navalunit =
  { id       = { type = 13500 id = 99 }
    name     = "1͑"
    location = 364
    base     = 364
    division =
    { id    = { type = 13500 id = 100 }
      name  = "1Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13500 id = 101 }
      name  = "2Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13500 id = 102 }
      name  = "3Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13500 id = 103 }
      name  = "4Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13500 id = 104 }
      name  = "5Q"
      type  = submarine
      model = 0
    }
  }
  navalunit =
  { id       = { type = 13500 id = 105 }
    name     = "2͑"
    location = 364
    base     = 364
    division =
    { id    = { type = 13500 id = 106 }
      name  = "6Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13500 id = 107 }
      name  = "7Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13500 id = 108 }
      name  = "8Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13500 id = 109 }
      name  = "9Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 13500 id = 110 }
      name  = "10Q"
      type  = submarine
      model = 2
    }
  }
  navalunit =
  { id       = { type = 13500 id = 120 }
    name     = "3͑"
    location = 949
    base     = 949
    division =
    { id    = { type = 13500 id = 121 }
      name  = "11Q"
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 13500 id = 122 }
      name  = "12Q"
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 13500 id = 123 }
      name  = "13Q"
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 13500 id = 124 }
      name  = "14Q"
      type  = submarine
      model = 2
    }
    division =
    { id    = { type = 13500 id = 125 }
      name  = "15Q"
      type  = submarine
      model = 2
    }
  }
  navalunit =
  { id       = { type = 13500 id = 126 }
    location = 1337
    base     = 1337
    name     = "A"
    division =
    { id   = { type = 13500 id = 127 }
      name = "1AQ"
      type = transport
    }
    division =
    { id   = { type = 13500 id = 128 }
      name = "2AQ"
      type = transport
    }
    division =
    { id   = { type = 13500 id = 129 }
      name = "3AQ"
      type = transport
    }
  }
  navalunit =
  { id       = { type = 13500 id = 130 }
    location = 364
    base     = 364
    name     = "{A"
    division =
    { id   = { type = 13500 id = 131 }
      name = "4AQ"
      type = transport
    }
    division =
    { id   = { type = 13500 id = 132 }
      name = "5AQ"
      type = transport
    }
    division =
    { id   = { type = 13500 id = 133 }
      name = "6AQ"
      type = transport
    }
    division =
    { id   = { type = 13500 id = 134 }
      name = "7AQ"
      type = transport
    }
  }
  # ##################################
  # ######## France Air OOB ##########
  # ##################################
  airunit =
  { id       = { type = 13500 id = 135 }
    name     = "1q"
    location = 56
    base     = 56
    division =
    { id       = { type = 13500 id = 136 }
      name     = "1pq"
      strength = 100
      type     = tactical_bomber
    }
    division =
    { id       = { type = 13500 id = 137 }
      name     = "2pq"
      strength = 100
      type     = tactical_bomber
    }
    division =
    { id       = { type = 13500 id = 138 }
      name     = "3pq"
      strength = 100
      type     = tactical_bomber
    }
  }
  airunit =
  { location = 949
    base     = 949
    id       = { type = 13500 id = 139 }
    name     = "4q"
    division =
    { id       = { type = 13500 id = 140 }
      name     = "6pq"
      strength = 100
      type     = tactical_bomber
    }
  }
  airunit =
  { location = 364
    base     = 364
    id       = { type = 13500 id = 141 }
    name     = "5q"
    division =
    { id       = { type = 13500 id = 142 }
      name     = "7pq"
      strength = 100
      type     = tactical_bomber
    }
  }
  airunit =
  { location = 56
    base     = 56
    id       = { type = 13500 id = 143 }
    name     = "1퓬q"
    division =
    { id       = { type = 13500 id = 144 }
      name     = "24퓬q"
      strength = 100
      type     = interceptor
      model    = 1
    }
    division =
    { id       = { type = 13500 id = 145 }
      name     = "21퓬q"
      strength = 100
      type     = interceptor
      model    = 1
    }
  }
  airunit =
  { location = 364
    base     = 364
    id       = { type = 13500 id = 146 }
    name     = "3퓬q"
    division =
    { id       = { type = 13500 id = 147 }
      name     = "23퓬q"
      strength = 100
      type     = interceptor
    }
  }
  # #################################
  # Naval units under construction
  # #################################
  division_development =
  { name  = "_PN"
    type  = battlecruiser
    model = 3
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      extra4 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
      brigade_model4 = 1
    cost  = 5.5
    id    = { type = 13500 id = 148 }
    date  = { year = 1937 month = april day = 1 }
  }
  division_development =
  { name  = "XgXu["
    type  = battlecruiser
    model = 3
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      extra4 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
      brigade_model4 = 1
    cost  = 5.5
    id    = { type = 13500 id = 149 }
    date  = { year = 1939 month = april day = 1 }
  }
  division_development =
  { name  = "V["
    type  = battleship
    model = 2
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      extra4 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 1
      brigade_model4 = 1
    cost  = 5.4
    id    = { type = 13500 id = 150 }
    date  = { year = 1939 month = september day = 1 }
  }
  division_development =
  { name  = "WW=CO"
    type  = light_cruiser
    model = 3
      extra1 = naval_anti_air_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 1
    cost  = 2.9
    id    = { type = 13500 id = 151 }
    date  = { year = 1937 month = april day = 1 }
  }
  division_development =
  { name  = "OA["
    type  = light_cruiser
    model = 3
      extra1 = naval_anti_air_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 1
    cost  = 2.9
    id    = { type = 13500 id = 152 }
    date  = { year = 1937 month = april day = 1 }
  }
  division_development =
  { name  = "WEhEBGk"
    type  = light_cruiser
    model = 3
      extra1 = naval_anti_air_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 1
    cost  = 2.9
    id    = { type = 13500 id = 153 }
    date  = { year = 1937 month = january day = 1 }
  }
  division_development =
  { name  = "}ZCG[Y"
    type  = light_cruiser
    model = 3
      extra1 = naval_anti_air_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 1
    cost  = 2.9
    id    = { type = 13500 id = 154 }
    date  = { year = 1937 month = april day = 1 }
  }
  division_development =
  { name  = "J"
    type  = light_cruiser
    model = 3
      extra1 = naval_anti_air_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 1
    cost  = 2.9
    id    = { type = 13500 id = 155 }
    date  = { year = 1937 month = april day = 1 }
  }
}
