
##############################
# Country definition for ITA #
##############################

province =
{ id         = 368
  landfort   = { size = 5 current_size = 5 }
  anti_air   = { size = 3 current_size = 3 }
  naval_base = { size = 10 current_size = 10 }
  air_base   = { size = 10 current_size = 10 }
}              # Genoa
province =
{ id         = 369
  anti_air   = { size = 3 current_size = 3 }
  naval_base = { size = 10 current_size = 10 }
}              # La Spezia
province =
{ id       = 370
  air_base = { size = 4 current_size = 4 }
  anti_air = { size = 3 current_size = 3 }
}            # Milan
province =
{ id         = 378
  anti_air   = { size = 2 current_size = 2 }
  naval_base = { size = 10 current_size = 10 }
  air_base   = { size = 10 current_size = 10 }
}              # Venice
province =
{ id       = 399
  air_base = { size = 4 current_size = 4 }
}            # Rhodes
province = { id = 512 anti_air = { size = 1 current_size = 1 } } # Bologna
province = { id = 513 anti_air = { size = 1 current_size = 1 } } # Florence
province =
{ id       = 515
  anti_air = { size = 1 current_size = 1 }
  air_base = { size = 10 current_size = 10 }
}            # Rome
province =
{ id       = 521
  air_base = { size = 4 current_size = 4 }
}            # Naples
province =
{ id         = 523
  anti_air   = { size = 1 current_size = 1 }
  naval_base = { size = 10 current_size = 10 }
  air_base   = { size = 10 current_size = 10 }
}              # Taranto
province =
{ id         = 525
  anti_air   = { size = 2 current_size = 2 }
  naval_base = { size = 10 current_size = 10 }
  air_base   = { size = 10 current_size = 10 }
}              # Palermo
province = { id = 531 landfort = { size = 5 current_size = 5 } anti_air = { size = 3 current_size = 3 } } # Turin
province =
{ id         = 534
  anti_air   = { size = 1 current_size = 1 }
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 4 current_size = 4 }
  oilpool    = 100
  supplypool = 800
}              # Sardinia
province =
{ id         = 919
  anti_air   = { size = 2 current_size = 2 }
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 2 current_size = 2 }
  landfort   = { size = 3 current_size = 3 }
}              # Tobruk
province =
{ id         = 924
  anti_air   = { size = 1 current_size = 1 }
  naval_base = { size = 5 current_size = 5 }
  air_base   = { size = 4 current_size = 4 }
}              # Bengazi
province =
{ id         = 932
  anti_air   = { size = 1 current_size = 1 }
  naval_base = { size = 10 current_size = 10 }
  air_base   = { size = 10 current_size = 10 }
  oilpool    = 100
  supplypool = 300
}              # Tripoli
province =
{ id         = 1033
  anti_air   = { size = 1 current_size = 1 }
  naval_base = { size = 2 current_size = 2 }
  air_base   = { size = 4 current_size = 4 }
  oilpool    = 100
  supplypool = 300
}              # Massaua

#####################
# 83 new airports built to cope with the war - Modified by Cardus 
# ref ref http://www.aeronautica.difesa.it/storiaTradizione/LaStoria/Pagine/guerreEtiopiaSpagna.aspx
#####################

province =
{ id         = 1038
  air_base   = { size = 2 current_size = 2 }
}              # Assab
province =
{ id         = 1056
  air_base   = { size = 2 current_size = 2 }
}              # Mogadishu
province =
{ id         = 1034
  air_base   = { size = 1 current_size = 1 }
}              # Obbia
province =
{ id         = 1055
  air_base   = { size = 1 current_size = 1 }
}              # Bardera

province = { id = 1056 oilpool = 100 supplypool = 300 } # Mogadishu

#####################
# Country main data #
#####################

country =
{ tag                    = ITA
  manpower               = 900
  # Resource Reserves
  energy                 = 1000
  metal                  = 1000
  rare_materials         = 500
  oil                    = 500
  supplies               = 2000
  money                  = 50
  belligerence           = 0 # to avoid MP problems
  capital                = 515
  transports             = 400
  escorts                = 100
  # Illyrian Coast
  diplomacy =
  { relation = { tag = AFG value = 50 }
    relation =
    { tag        = ALB
      value      = 10
      guaranteed = { day = 17 month = march year = 1934 }
    }
    relation = { tag = ARG value = 30 }
    relation = { tag = AST value = 1 }
    relation =
    { tag        = AUS
      value      = 125
      guaranteed = { day = 17 month = march year = 1934 }
    }
    relation = { tag = BEL value = -5 }
    relation = { tag = BHU value = 1 }
    relation = { tag = BUL value = 150 }
    relation = { tag = CAN value = 1 }
    relation = { tag = CHL value = 30 }
    relation = { tag = CZE value = 15 }
    relation = { tag = ENG value = -50 }
    relation = { tag = ETH value = -200 }
    relation = { tag = FIN value = 50 }
    relation = { tag = FRA value = -50 }
    relation = { tag = GER value = 50 }
    relation =
    { tag        = GRE
      value      = -35
      guaranteed = { day = 17 month = march year = 1934 }
    }
    relation = { tag = HOL value = -20 }
    relation =
    { tag        = HUN
      value      = 125
      guaranteed = { day = 17 month = march year = 1934 }
    }
    relation = { tag = IRE value = 20 }
    relation = { tag = IRQ value = 25 }
    relation = { tag = NEP value = 1 }
    relation = { tag = NZL value = 1 }
    relation = { tag = OMN value = 50 }
    relation = { tag = POR value = 65 }
    relation =
    { tag        = ROM
      value      = 50
      guaranteed = { day = 17 month = march year = 1934 }
    }
    relation = { tag = SAF value = 1 }
    relation = { tag = SAU value = -25 }
    relation =
    { tag        = SCH
      value      = 1
      guaranteed = { day = 16 month = may year = 1935 }
    }
    relation = { tag = SPR value = -50 }
    relation =
    { tag        = TUR
      value      = 1
      guaranteed = { day = 17 month = march year = 1934 }
    }
    relation = { tag = YEM value = 50 }
    relation = { tag = YUG value = 75 }
  }
  SpyInfo                = { country = "ITA" NumberOfSpies = 5 }
  SpyInfo                = { country = "ENG" NumberOfSpies = 3 }
  SpyInfo                = { country = "FRA" NumberOfSpies = 4 }
  SpyInfo                = { country = "SOV" NumberOfSpies = 2 }
  SpyInfo                = { country = "CZE" NumberOfSpies = 2 }
  SpyInfo                = { country = "AUS" NumberOfSpies = 3 }
  SpyInfo                = { country = "SPR" NumberOfSpies = 3 }
  SpyInfo                = { country = "POL" NumberOfSpies = 2 }
  SpyInfo                = { country = "SWE" NumberOfSpies = 1 }
  SpyInfo                = { country = "NOR" NumberOfSpies = 1 }
  SpyInfo                = { country = "FIN" NumberOfSpies = 1 }
  SpyInfo                = { country = "YUG" NumberOfSpies = 4 }
  SpyInfo                = { country = "HUN" NumberOfSpies = 2 }
  SpyInfo                = { country = "BUL" NumberOfSpies = 2 }
  SpyInfo                = { country = "BEL" NumberOfSpies = 1 }
  SpyInfo                = { country = "DEN" NumberOfSpies = 1 }
  SpyInfo                = { country = "HOL" NumberOfSpies = 1 }
  SpyInfo                = { country = "ARG" NumberOfSpies = 3 }
  SpyInfo                = { country = "USA" NumberOfSpies = 3 }
  SpyInfo                = { country = "ALB" NumberOfSpies = 2 }
  SpyInfo                = { country = "GRE" NumberOfSpies = 1 }
  SpyInfo                = { country = "JAP" NumberOfSpies = 1 }
  SpyInfo                = { country = "ROM" NumberOfSpies = 1 }
  SpyInfo                = { country = "TUR" NumberOfSpies = 4 }
  SpyInfo                = { country = "POR" NumberOfSpies = 1 }
  SpyInfo                = { country = "GER" NumberOfSpies = 3 }


  nationalidentity = "policy_identity_parochial"
	socialpolicy = "policy_social_conformism"
	nationalculture = "policy_culture_ethnic"

  # Somaliland
  nationalprovinces      = { 525 526 524 523 522 521 520 519 518 517 516 515 513 514 512 379 369 368 531 370 371 378 534 381 384 387 388 389 }
  ownedprovinces         = { 525  526  524  523  522  521  520  519  518  517  516  515  513  514  512  379  369  368  531  370  371  378  534  398 
                             399  927  933  932  930  929  925  924  923  922  921  920  919  916  917  918  926  928  931  1017 1018 1016 1015 1033
                             1039 1038 1034 1055 1056 1058
                           }
  # Somaliland
  controlledprovinces    = { 525  526  524  523  522  521  520  519  518  517  516  515  513  514  512  379  369  368  531  370  371  378  534  398 
                             399  927  933  932  930  929  925  924  923  922  921  920  919  916  917  918  926  928  931  1017 1018 1016 1015 1033
                             1039 1038 1034 1055 1056 1058
                           }
  # ITA 1936 techs
  # ######################
  # Early fighter
  techapps               = { 6120  4010  4120  4130  4190  4250  2150  2010  2020  2030  2290  2300  2310  2450  1010  1020  1190  1200  1110  5010 
                             5080  5090  5190  5310  5320  5470  5480  9010  9020  9030  6010  6030  8010  8020  8030  8040  8050  8070  8120  3010 
                             3020  3030  3070  3080  3090  3130  3140  3150  3190  3250  3260  3270  3280  3400  3410  3420  14000 3100  3320  5020
                           }
  policy =
  { date              = { year = 0 month = january day = 0 }
    democratic        = 2
    political_left    = 3
    freedom           = 4
    free_market       = 7
    professional_army = 3
    defense_lobby     = 7
    interventionism   = 6
  }
  headofstate            = { type = 9 id = 3001 }
  headofgovernment       = { type = 9 id = 3002 }
  foreignminister        = { type = 9 id = 3003 }
  armamentminister       = { type = 9 id = 3076 }
  ministerofsecurity     = { type = 9 id = 3005 }
  ministerofintelligence = { type = 9 id = 3006 }
  chiefofstaff           = { type = 9 id = 3007 }
  chiefofarmy            = { type = 9 id = 3008 }
  chiefofnavy            = { type = 9 id = 3009 }
  chiefofair             = { type = 9 id = 3010 }

 ###############################################
 ############ Land OOB #########################
 ###############################################
  landunit =
  { id       = { type = 23500 id = 1 }
    location = 531 # Turin
    name     = "IR" #ȍ~AArA[}ɕύXĂ镔B
    division =
    { id            = { type = 23500 id = 3 }
      name          = "22tcuİإޯڥ߁v"
      type          = infantry
      extra         = artillery
      brigade_model = 2
      strength      = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 4 }
    location = 531 # Turin
    name     = "IIRc"
    division =
    { id       = { type = 23500 id = 5 }
      name     = "4tcuHmv"
      type     = infantry
      strength = 70
      model    = 1
    }
    division =
    { id       = { type = 23500 id = 6 }
      name     = "25tcu{[jv"
      type     = infantry
      strength = 70
    }
    division =
    { id       = { type = 23500 id = 7 }
      name     = "4RxtcuNl[[v"
      type     = bergsjaeger
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 8 }
    location = 531 # Turin
    name     = "IIIRc"
    division =
    { id       = { type = 23500 id = 9 }
      name     = "3tcuFiv"
      type     = infantry
      strength = 70
    }
    division =
    { id       = { type = 23500 id = 10 }
      name     = "6tcuN[lIv"
      type     = infantry
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 11 }
    location = 378 # Venezia
    name     = "IIR"
    division =
    { id            = { type = 23500 id = 12 }
      name          = "13tcuv"
      type          = infantry
      extra         = artillery
      brigade_model = 2
      strength      = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 13 }
    location = 378 # Venezia
    name     = "VRc"
    # Gen. R. Balocco#
    division =
    { id       = { type = 23500 id = 14 }
      name     = "12tcuTbTv"
      type     = infantry
      strength = 70
    }
    division =
    { id       = { type = 23500 id = 15 }
      name     = "15tcuxKv"
      type     = infantry
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 16 }
    location = 378 # Venezia
    name     = "VIIIRc"
    # Gen. F Gambelli#
    division =
    { id       = { type = 23500 id = 17 }
      name     = "9tcupY[rIv"
      type     = infantry
      strength = 70
    }
    division =
    { id       = { type = 23500 id = 18 }
      name     = "10tcusA[Fv"
      type     = infantry
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 19 }
    location = 378 # Venezia
    name     = "XIRc"
    # Gen. C. Mercalli#
    division =
    { id       = { type = 23500 id = 20 }
      name     = "14tcuC\cHv"
      type     = infantry
      strength = 70
    }
    division =
    { id       = { type = 23500 id = 21 }
      name     = "3RxtcuWAv"
      type     = bergsjaeger
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 2 }
    location = 919
    name     = "kRiߕ"
    division =
    { id       = { type = 23500 id = 22 }
      name     = "18tcubV[iv"
      type     = infantry
      model    = 1
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 23 }
    location = 378 # Venezia
    name     = "Rc"
    # Gen. G. Messe#
    division =
    { id       = { type = 23500 id = 24 }
      name     = "1tcuުƵިޫv"
      type     = cavalry
      strength = 70
      model    = 1
    }
    division =
    { id       = { type = 23500 id = 25 }
      name     = "2tcuG}kG[EtBxgv"
      type     = cavalry
      strength = 70
      model    = 1
    }
    division =
    { id       = { type = 23500 id = 26 }
      name     = "3tcuv`yEAf[Iv"
      type     = cavalry
      strength = 70
      model    = 1
      extra    = armored_car
    }
  }
  landunit =
  { id       = { type = 23500 id = 27 }
    location = 524 # Reggio di Calabria
    name     = "IIIR"
    division =
    { id            = { type = 23500 id = 28 }
      name          = "16tcusXgCAv"
      type          = infantry
      extra         = artillery
      brigade_model = 2
      strength      = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 30 }
    location = 524 # Reggio di Calabria
    name     = "VIIRc"
    # Gen. A. Agromini#
    division =
    { id       = { type = 23500 id = 31 }
      name     = "7tcusEfBEgXJ[iv"
      type     = infantry
      strength = 70
    }
    division =
    { id       = { type = 23500 id = 32 }
      name     = "20tcutE[v"
      type     = infantry
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 33 }
    location = 524 # Reggio di Calabria
    name     = "IXRc"
    # Gen. C.Rossi#
    division =
    { id       = { type = 23500 id = 34 }
      name     = "17tcupB[Av"
      type     = infantry
      strength = 70
    }
    division =
    { id       = { type = 23500 id = 35 }
      name     = "23tcutF[v"
      type     = infantry
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 36 }
    location = 525 # Palermo
    name     = "XIIRc"
    # Gen. A.Rossi#
    division =
    { id       = { type = 23500 id = 37 }
      name     = "28tcuAIX^v"
      type     = infantry
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 38 }
    location = 525 # Palermo
    name     = "XIIIRc"
    division =
    { id       = { type = 23500 id = 39 }
      name     = "31tcuJuAv"
      type     = infantry
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 40 }
    location = 368 # Genoa
    name     = "IVR"
    # Gen. A Guzzoni#
    division =
    { id            = { type = 23500 id = 41 }
      name          = "11tcuulv"
      type          = infantry
      extra         = artillery
      brigade_model = 2
      strength      = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 43 }
    location = 368 # Genoa
    name     = "IRc"
    # Gen. C. Vecchiarelli#
    division =
    { id       = { type = 23500 id = 44 }
      name     = "1tcuXyKv"
      type     = infantry
      extra    = armored_car
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 45 }
    location = 368 # Genoa
    name     = "IVRc"
    # Gen. C. Mercalli#
    division =
    { id       = { type = 23500 id = 46 }
      name     = "2tcuXtHcFXJv"
      type     = infantry
      extra    = armored_car
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 47 }
    location = 368 # Genoa
    name     = "RxRc"
    # Gen. L. Negri#
    division =
    { id       = { type = 23500 id = 48 }
      name     = "1Rxtcu^El[[v"
      type     = bergsjaeger
      strength = 70
    }
    division =
    { id       = { type = 23500 id = 49 }
      name     = "2RxtcugfeBiv"
      type     = bergsjaeger
      strength = 70
    }
  }
  landunit =
  { id       = { type = 23500 id = 50 }
    location = 515 # Roma
    name     = "\"
    division =
    { id       = { type = 23500 id = 190 }
      name     = "Riߕ"   #new hq
      type     = hq
      model    = 0
      strength = 70
    }
    division =
    { id       = { type = 23500 id = 51 }
      name     = "21tcuè؁EިEްƬv"
      type     = infantry
      strength = 70		#reduced the strenght
    }
    #removed from AOI and placed in Rome as central reserve, strenght reduced from 100 to 70
	division =
    { id       = { type = 23500 id = 61 }
      name     = "19tcuFlcBAv"
      type     = infantry
      model    = 1
      extra    = armored_car
      strength = 70
   }
    division =
    { id       = { type = 23500 id = 62 }
      name     = "24tcusl[v"
      type     = infantry
      model    = 1
      strength = 70
   }
    division =
    { id       = { type = 23500 id = 65 }
      name     = "27tcuuVAv"
      type     = infantry
      model    = 1
      strength = 70
    }
   division =
    { id       = { type = 23500 id = 75 }
      name     = "29tcusGev"
      type     = infantry
      model    = 1
      strength = 70
    }
 }
####################################################################################
#OOB Italian Troops Campagna d'Africa 1935-1936 by Cardus
# ref. http://www.regioesercito.it/reparti/mvsn/mvsn_et35.htm
# ref http://digilander.libero.it/fiammecremisi/dopoguerra1/etiopia.htm
# ref http://it.wikipedia.org/wiki/Guerra_d%27Etiopia
# ref http://www.aeronautica.difesa.it/storiaTradizione/LaStoria/Pagine/guerreEtiopiaSpagna.aspx
#####################################################################################

  landunit =
  { id       = { type = 23500 id = 52 }
    location = 1033
    name     = "ɗ̓iߕ"
	#Maresciallo Badoglio#
    division =
    { id       = { type = 23500 id = 53 }
      name     = "ɗ̓Riߕ"
      type     = hq
      model    = 0
      extra = engineer
      strength = 100
    }
    #Div Gran Sasso is with the II CORPO D'ARMATA
    #Div Sila is with the III CORPO D'ARMATA
	#CC.NN. '1 Febbraio'is with IV CORPO D'ARMATA
	#6a Divisione CC.NN. 'Tevere' is with Forze Armate della Somalia
    division =
    { id       = { type = 23500 id = 59 }
      name     = "4Vctcu3EWFi[CIv"
	  #Gen. Alessandro Traditi
      type     = militia
      strength = 100
    }
  }
  landunit =
  { id       = { type = 23500 id = 55 }
    location = 1038
    name     = "ɗ̓IRc"
    # Gen. Santini
    division =
    { id       = { type = 23500 id = 56 }
      name     = "26tcuAbVGb^v"
      #Gen. Enrico Riccardi
	  type     = infantry
      model    = 1
	  extra = artillery
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 57 }
      name     = "30tcuToE_v"
      #
	  type     = infantry
      model    = 1
	  extra = artillery	  
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 58 }
      name     = "5RxtcuvXe[Av"
      type     = bergsjaeger
	  extra = artillery	  
      strength = 100
    }
    division =
	{ id       = { type = 23500 id = 180 }
      name     = "V-XVylcuVc@[iv" # 
      type     = militia
      strength = 100
	  extra = armored_car
    }
  }
  landunit =
  { id       = { type = 23500 id = 60 }
    location = 1039
    name     = "ɗ̓IIRc"
    # Gen. Maravigna
#    division =
#    { id       = { type = 23500 id = 61 }
#      name     = "19tcuFlcBAv"
#      type     = infantry
#      model    = 1
#      extra    = armored_car
#      strength = 100
#   }
#    division =
#    { id       = { type = 23500 id = 62 }
#      name     = "24tcusl[v"
#      type     = infantry
#      model    = 1
#      strength = 70
#   }
    division =
	{ id       = { type = 23500 id = 181 }
      name     = "19tcuKBi[iv"
	  #Gen. Nino Villasanta
      type     = infantry
      model    = 1
	  extra = artillery	  
      strength = 100
    }
    division =
    { id            = { type = 23500 id = 182 }
      name          = "24tcuOETb\v"
	  #Gen. A.R. Adalberto di Savoia
      type          = infantry
      model         = 1
      extra = artillery
      strength      = 100
    }
    division =
    { id       = { type = 23500 id = 63 }
      name     = "3Vctcu21EAv[v"
	  #Gen. Giacomo Appiotti
      type     = militia
	  extra = artillery
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 184 }
      name     = "Serae Cheren Hamasien nyltc" # SeraeEPEn}Z / ctc / " Gr." ͖BȉlB
	  type     = militia
	  extra = armored_car
      strength = 100
    }
  } 

  landunit =
  { id       = { type = 23500 id = 64 }
    location = 1038
    name     = "ɗ̓IIIRc"
    # Gen. Bastico
#    division =
#    { id       = { type = 23500 id = 65 }
#      name     = "27tcuuVAv"
#      type     = infantry
#      model    = 1
#      strength = 100
#    }
	division =
    { id            = { type = 23500 id = 183 }
      name          = "27tcuYBv"
	  #Gen. Francesco Bertini
      type          = infantry
      model         = 1
      extra = artillery
      strength      = 100
    }
    division =
    { id       = { type = 23500 id = 66 }
      name     = "1Vctcu23E}cHv"
	  #Gen. Domenico Siciliani
      type     = militia
      strength = 100
    }
  }
  landunit =
  { id       = { type = 23500 id = 67 }
    location = 1039
    name     = "ɗ̓IVRc"
    # Gen. Babbini#
    division =
    { id       = { type = 23500 id = 68 }
      name     = "5tcuRbZ[Av"
	  #Gen. Adolfo Olivetti
      type     = infantry
      model    = 1
	  extra = artillery
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 69 }
      name     = "2Vctcu28EIbg[rv"
	  #Gen. Umberto Somma
      type     = militia
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 70 }
      name     = "5Vctcu1EtFbu[CIv"
	  #Gen. Attilio Teruzzi
      type     = militia
      strength = 100
    }
  }
  landunit =
  { id       = { type = 23500 id = 71 }
    location = 1039
    name     = "GgARc"
    # Gen. Pirzio Biroli#
    division =
    { id       = { type = 23500 id = 72 }
      name     = "1tcuGgAv"
      type     = infantry
      model    = 1
  	  extra = artillery
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 73 }
      name     = "2tcuGgAv"
      type     = infantry
      model    = 1
  	  extra = artillery
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 185 }
      name     = "1GgAVctc" # tcB
      type     = militia
  	  extra = artillery
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 186 }
      name     = "ylRtc" # tc
      type     = cavalry
 	  extra = armored_car 
	  strength = 100
    }
    division =
    { id       = { type = 23500 id = 187 }
      name     = "AbT[tc" # ctc
      type     = militia
  	  extra = artillery
      strength = 100
    }
  }
  landunit =
  { id       = { type = 23500 id = 74 }
    location = 1034 # Obbia
    name     = "\}AR"
    # Gen. Graziani#
#    division =
#    { id       = { type = 23500 id = 75 }
#      name     = "29tcusGev"
#      type     = infantry
#      model    = 1
#     strength = 100
#    }
    division =
    { id       = { type = 23500 id = 188 }
      name     = "\}ARiߕ"
      type     = hq
      model    = 0
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 189 }
      name     = "29tcuy^[iv"
	  #Gen. sisto Bertoldi
      type     = infantry
	  model    = 1
	  extra = artillery
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 76 }
      name     = "rAtc"
	  #Gen. Guglielmo Nasi
      type     = infantry
	  model    = 1
  	  extra = artillery
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 77 }
      name     = "6VctcueFv"
	  #Gen. Enrico Boscardi
      type     = militia
      strength = 100
    }
    division =
    { id       = { type = 23500 id = 78 }
      name     = "7Vctcu`[lv"
      type     = militia
      strength = 100
    }
  } 
  # ###########################################
	### Italian Navy OOB ###
  # ###########################################
  navalunit =
  { id       = { type = 23500 id = 79 }
    name     = "CR"
    location = 523 # Taranto
    base     = 523
    division =
    { id    = { type = 23500 id = 80 }
      name  = "2"
      type  = destroyer
      model = 1
      extra1 = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 81 }
      name  = "RN AhAEhA"
      type  = battleship
      model = 0
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = none
      extra4 = naval_anti_air_l
      extra5 = none
      brigade_model1 = 0
      brigade_model2 = 1
      brigade_model3 = 0
      brigade_model4 = 0
      brigade_model5 = 0
    }
    division =
    { id    = { type = 23500 id = 82 }
      name  = "RN JCIEhDCI"
      type  = battleship
      model = 0
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = none
      extra4 = naval_anti_air_l
      extra5 = none
      brigade_model1 = 0
      brigade_model2 = 1
      brigade_model3 = 0
      brigade_model4 = 0
      brigade_model5 = 0
    }
    division =
    { id    = { type = 23500 id = 83 }
      name  = "RN Jp[jA"
      type  = heavy_cruiser
      model = 0
      extra1 = none
      extra2 = none
      extra3 = none
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 23500 id = 84 }
      name  = "RN TE}R"
      type  = heavy_cruiser
      model = 0
      extra1 = none
      extra2 = none
      extra3 = none
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 23500 id = 85 }
      name  = "RN TEWW"
      type  = heavy_cruiser
      model = 0
      extra1 = none
      extra2 = none
      extra3 = none
      brigade_model1 = 0
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 23500 id = 86 }
      name  = "RN ^[g"
      type  = light_cruiser
      model = 0
      extra1 = naval_fire_controll_s
      extra2 = naval_anti_air_s
      brigade_model1 = 1
      brigade_model2 = 0
    }
    division =
    { id    = { type = 23500 id = 87 }
      name  = "RN o["
      type  = light_cruiser
      model = 0
      extra1 = naval_fire_controll_s
      extra2 = naval_anti_air_s
      brigade_model1 = 1
      brigade_model2 = 0
    }
    division =
    { id    = { type = 23500 id = 88 }
      name  = "RN rA"
      type  = light_cruiser
      model = 0
      extra1 = none
      extra2 = none
      brigade_model1 = 0
      brigade_model2 = 0
    }
    division =
    { id    = { type = 23500 id = 196 }
      name  = "RN AR[i"
      type  = light_cruiser
      model = 0
      extra1 = none
      extra2 = none
      brigade_model1 = 0
      brigade_model2 = 0
    }
    division =
    { id    = { type = 23500 id = 89 }
      name  = "17쒀"
      type  = destroyer
      model = 0
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 90 }
      name  = "18쒀"
      type  = destroyer
      model = 0
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 91 }
      name  = "2Q"
      type  = destroyer
      model = 0
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 92 }
      name  = "3Q"
      type  = destroyer
      model = 0
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
    division =
    { id    = { type = 23500 id = 93 }
      name  = "21쒀"
      type  = destroyer
      model = 0
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 94 }
      name  = "22쒀"
      type  = destroyer
      model = 0
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 95 }
      name  = "6Q"
      type  = destroyer
      model = 0
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 96 }
      name  = "7Q"
      type  = destroyer
      model = 0
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 97 }
      name  = "15Q"
      type  = destroyer
      model = 0
      extra1    = none
      brigade_model1 = 0
    }
  }
  navalunit =
  { id       = { type = 23500 id = 98 }
    name     = "1"
    location = 523 # Taranto
    base     = 523
    division =
    { id    = { type = 23500 id = 99 }
      name  = "RN U"
      type  = heavy_cruiser
      model = 2
      extra1 = naval_fire_controll_l
      extra2 = naval_spotter_l
      extra3 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 23500 id = 100 }
      name  = "RN ScBA"
      type  = heavy_cruiser
      model = 2
      extra1 = naval_fire_controll_l
      extra2 = naval_spotter_l
      extra3 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 23500 id = 101 }
      name  = "RN t["
      type  = heavy_cruiser
      model = 2
      extra1 = naval_fire_controll_l
      extra2 = naval_spotter_l
      extra3 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 23500 id = 102 }
      name  = "9쒀"
      type  = destroyer
      model = 1
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 103 }
      name  = "WWEIV[j"
      type  = transport
      model = 0
    }
    division =
    { id    = { type = 23500 id = 104 }
      name  = "^NC[jA"
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 23500 id = 105 }
    name     = "4"
    location = 378 # Venice
    base     = 378
    division =
    { id       = { type = 23500 id = 106 }
      name     = "RN AxRE_EorA[m"
      type     = light_cruiser
      model    = 1
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
      maxspeed = 34
    }
    division =
    { id    = { type = 23500 id = 107 }
      name  = "RN C[WEJhi"
      type  = light_cruiser
      model = 1
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
    }
    division =
    { id       = { type = 23500 id = 108 }
      name     = "RN AxgE_EWbT[m" # "da" ł͂Ȃ"di" ƂH
      type     = light_cruiser
      model    = 1
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
      maxspeed = 34
    }
    division =
    { id    = { type = 23500 id = 109 }
      name  = "RN A}hEfBAY"
      type  = light_cruiser
      model = 1
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
    }
    division =
    { id    = { type = 23500 id = 110 }
      name  = "AFeB[m"
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 23500 id = 111 }
    name     = "5"
    location = 523 # Taranto
    base     = 523
    division =
    { id    = { type = 23500 id = 112 }
      name  = "7쒀"
      type  = destroyer
      model = 2
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 113 }
      name  = "8쒀"
      type  = destroyer
      model = 2
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 114 }
      name  = "TW^I"
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 23500 id = 115 }
    name     = "8"
    location = 378 # Venice
    base     = 378
    division =
    { id    = { type = 23500 id = 116 }
      name  = "16쒀"
      type  = destroyer
      model = 1
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
  }
  navalunit =
  { id       = { type = 23500 id = 195 }
    name     = "10" # _uĂׁAɕύX
    location = 378 # Venice
    base     = 378
    division =
    { id    = { type = 23500 id = 179 }
      name  = "15쒀"
      type  = destroyer
      model = 1
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
  }
  navalunit =
  { id       = { type = 23500 id = 117 }
    name     = "9"
    location = 523 # Taranto
    base     = 523
    division =
    { id    = { type = 23500 id = 118 }
      name  = "RN |["
      type  = heavy_cruiser
      model = 2
      extra1 = naval_fire_controll_l
      extra2 = naval_spotter_l
      extra3 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 0
      brigade_model3 = 0
    }
  }
  navalunit =
  { id       = { type = 23500 id = 119 }
    name     = "19"
    location = 932 # Tripoli
    base     = 932
    division =
    { id       = { type = 23500 id = 120 }
      name     = "RN W@jEfEofEl["
      type     = light_cruiser
      model    = 1
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
      maxspeed = 34
    }
    division =
    { id       = { type = 23500 id = 121 }
      name     = "RN ogIERI[j"
      type     = light_cruiser
      model    = 1
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
      maxspeed = 34
    }
    division =
    { id    = { type = 23500 id = 122 }
      name  = "@bK"
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 23500 id = 123 }
    name     = "11"
    location = 368 # Genoa
    base     = 368
    division =
    { id    = { type = 23500 id = 124 }
      name  = "RN gg"
      type  = heavy_cruiser
      model = 1
      extra1 = naval_fire_controll_l
      extra2 = naval_spotter_l
      extra3 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 23500 id = 125 }
      name  = "RN {c@[m"
      type  = heavy_cruiser
      model = 2
      extra1 = naval_fire_controll_l
      extra2 = naval_spotter_l
      extra3 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 23500 id = 126 }
      name  = "RN gGXe"
      type  = heavy_cruiser
      model = 1
      extra1 = naval_fire_controll_l
      extra2 = naval_spotter_l
      extra3 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 0
      brigade_model3 = 0
    }
    division =
    { id    = { type = 23500 id = 127 }
      name  = "AX}"
      type  = transport
      model = 0
    }
  }
  navalunit =
  { id       = { type = 23500 id = 128 }
    name     = "17"
    location = 368 # Genoa
    base     = 368
    division =
    { id       = { type = 23500 id = 129 }
      name     = "RN fJEhEAIX^"
      type     = light_cruiser
      model    = 2
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
      maxspeed = 34
    }
    division =
    { id       = { type = 23500 id = 130 }
      name     = "RN cBIEAbeh["
      type     = light_cruiser
      model    = 2
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
      maxspeed = 34
    }
    division =
    { id       = { type = 23500 id = 131 }
      name     = "RN ChEeNbR"
      type     = light_cruiser
      model    = 2
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
      maxspeed = 34
    }
    division =
    { id    = { type = 23500 id = 132 }
      name  = "13쒀"
      type  = destroyer
      model = 0
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
  }
  navalunit =
  { id       = { type = 23500 id = 133 }
    name     = "1͑"
    location = 534
    base     = 534
    division =
    { id    = { type = 23500 id = 134 }
      name  = "4Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 23500 id = 135 }
      name  = "51Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 23500 id = 136 }
      name  = "52Q"
      type  = submarine
      model = 1
    }
  }
  navalunit =
  { id       = { type = 23500 id = 137 }
    name     = "2͑"
    location = 525 # Palermo
    base     = 525
    division =
    { id    = { type = 23500 id = 138 }
      name  = "11Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 23500 id = 139 }
      name  = "12Q"
      type  = submarine
      model = 1
    }
    division =
    { id    = { type = 23500 id = 140 }
      name  = "13Q"
      type  = submarine
      model = 1
    }
  }
  navalunit =
  { id       = { type = 23500 id = 141 }
    name     = "3͑"
    location = 378 # Venice
    base     = 378
    division =
    { id    = { type = 23500 id = 142 }
      name  = "21Q"
      type  = submarine
      model = 2
    }
  }
  navalunit =
  { id       = { type = 23500 id = 143 }
    name     = "4͑"
    location = 523 # Taranto
    base     = 523
    division =
    { id    = { type = 23500 id = 144 }
      name  = "31Q"
      type  = submarine
      model = 0
    }
    division =
    { id    = { type = 23500 id = 145 }
      name  = "33Q"
      type  = submarine
      model = 0
    }
  }
  navalunit =
  { id       = { type = 23500 id = 146 }
    name     = "5͑"
    location = 368 # Genoa
    base     = 368
    division =
    { id    = { type = 23500 id = 147 }
      name  = "40Q"
      type  = submarine
      model = 2
    }
  }
  navalunit =
  { id       = { type = 23500 id = 148 }
    name     = "rA͑" # Comando  ͑BKł͂܂B
    location = 932 # Tripoli
    base     = 932
    division =
    { id    = { type = 23500 id = 149 }
      name  = "1쒀"
      type  = destroyer
      model = 0
      extra1    = none
      brigade_model1 = 0
    }
  }
  navalunit =
  { id       = { type = 23500 id = 150 }
    name     = "6Q"
    location = 932 # Tripoli
    base     = 932
    division =
    { id    = { type = 23500 id = 151 }
      name  = "61Q"
      type  = submarine
      model = 2
    }
  }
  navalunit =
  { id       = { type = 23500 id = 152 }
    name     = "gC͑"
    location = 1033 # Massaua
    base     = 1033
    division =
    { id    = { type = 23500 id = 153 }
      name  = "3Q"
      type  = destroyer
      model = 0
      extra1    = none
      brigade_model1 = 0
    }
    division =
    { id    = { type = 23500 id = 154 }
      name  = "5쒀"
      type  = destroyer
      model = 0
      extra1 = naval_fire_controll_s
      brigade_model1 = 1
    }
  }
  #########################################
	### Italian Air OOB ###
  #########################################
  airunit =
  { location = 368
    base     = 368
    id       = { type = 23500 id = 155 }
    name     = "1q"
    division =
    { id       = { type = 23500 id = 156 }
      name     = "9퓬q" # ̕ύXBȍ~ȗB
      strength = 100
      type     = interceptor
      model    = 0
    }
  }
  airunit =
  { location = 534
    base     = 534
    id       = { type = 23500 id = 157 }
    name     = "4pquhSv"
    division =
    { id       = { type = 23500 id = 158 }
      name     = "4pquhSv"
      strength = 100
      type     = tactical_bomber
      model    = 0
    }
  }
  airunit =
  { location = 515
    base     = 515
    id       = { type = 23500 id = 160 }
    name     = "2q"
    division =
    { id       = { type = 23500 id = 161 }
      name     = "1퓬quANBv"
      strength = 50
      type     = interceptor
      model    = 0
    }
  }
  airunit =
  { location = 515
    base     = 515
    id       = { type = 23500 id = 162 }
    name     = "3qu`F^Ev" # 1 jbĝ݂Ȃ̂ŕύXBȍ~ȗB
    division =
    { id       = { type = 23500 id = 163 }
      name     = "3qu`F^Ev"
      strength = 100
      type     = naval_bomber
      model    = 0
    }
  }
  airunit =
  { location = 525
    base     = 525
    id       = { type = 23500 id = 164 }
    name     = "3q"
    division =
    { id       = { type = 23500 id = 165 }
      name     = "7퓬q"
      strength = 70 #reduced the strenght 
      type     = interceptor
      model    = 0
    }
    division =
	{ id       = { type = 23500 id = 177 }  # moved here from AOI
      name     = "14퓬quNXv"
      strength = 70
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 23500 id = 178 }	# moved here from AOI
      name     = "13pquyK\v"
      strength = 70
      type     = tactical_bomber
      model    = 0
    }
 }
  airunit =
  { location = 525
    base     = 525
    id       = { type = 23500 id = 166 }
    name     = "5quGIv"
    division =
    { id       = { type = 23500 id = 167 }
      name     = "5quGIv"
      strength = 50
      type     = naval_bomber
      model    = 0
    }
  }
  airunit =
  { location = 932
    base     = 932
    id       = { type = 23500 id = 168 }
    name     = "4q"
    division =
    { id       = { type = 23500 id = 169 }
      name     = "35pq"
      strength = 50
      type     = tactical_bomber
      model    = 0
    }
    division =
    { id       = { type = 23500 id = 170 }
      name     = "39Aq"
      strength = 50
      type     = transport_plane
      model    = 0
    }
  }
  airunit =
  { location = 534
    base     = 534
    id       = { type = 23500 id = 171 }
    name     = "TfB[jqc"
    division =
    { id       = { type = 23500 id = 172 }
      name     = "10qu}ev"
      strength = 80
      type     = naval_bomber
      model    = 0
    }
    division =
    { id       = { type = 23500 id = 173 }
      name     = "2퓬qu{Av"
      strength = 80
      type     = interceptor
      model    = 0
    }
  }
#####################################################################################
#OOB Italian Troops Campagna d'Africa 1935-1936 by Cardus 
# Approx. 500,000 combatants Approx. 595 aircraft Approx. 795 tanks 
# ref http://en.wikipedia.org/wiki/Second_Italo-Abyssinian_War#cite_note-Barker.2C_A._J._p._20-0 
# ref http://orbat.com/site/history/volume5/519/ItalianAirForceinItalianEastAfrica1919-1939PartI.pdf
# ref http://en.wikipedia.org/wiki/Italian_Order_of_Battle_Second_Italo-Abyssinian_War
#####################################################################################
  airunit =
  { location = 1033
    base     = 1033
    id       = { type = 23500 id = 174 }
    name     = "ɗ̓qc"
    division =
    { id       = { type = 23500 id = 175 }
      name     = "106퓬q"
      strength = 40
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 23500 id = 176 }
      name     = "4pq"
      strength = 20
      type     = tactical_bomber
      model    = 0
    }
    division =
    { id       = { type = 23500 id = 191 }
      name     = "27pq"
      strength = 10
      type     = tactical_bomber
      model    = 0
    }
  }
  airunit =
  { location = 1033
    base     = 1033
    id       = { type = 23500 id = 192 }
    name     = "\}Aqc"
	#Bgd. Gen. Ferruccio Ranza
    division =
    { id       = { type = 23500 id = 193 }
      name     = "106퓬q"
      strength = 10
      type     = interceptor
      model    = 0
    }
    division =
    { id       = { type = 23500 id = 194 }
      name     = "7pq"
      strength = 20
      type     = tactical_bomber
      model    = 0
    }
  }
#Units not in the OOB moved to Italy
#  airunit =
#  { location = 1033
#    base     = 1033
#    id       = { type = 23500 id = 174 }
#    name     = "ɗ̓qc"
#    division =
#    { id       = { type = 23500 id = 175 }
#      name     = "14퓬quNXv"
#      strength = 80
#      type     = interceptor
#      model    = 0
#    }
#    division =
#    { id       = { type = 23500 id = 176 }
#      name     = "13pquyK\v"
#      strength = 80
#      type     = tactical_bomber
#      model    = 0
#    }
#  }
#####################

  # ################################################
  	### Warships Under Construction ###
  # ################################################
  division_development =
  { name  = "RN bgI"
    type  = battleship
    model = 3
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      extra4 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 0
      brigade_model4 = 1
    cost  = 6.9
    id    = { type = 23500 id = 201 }
    date  = { year = 1939 month = april day = 11 }
  }
  division_development =
  { name  = "RN BbgIEFlg"
    type  = battleship
    model = 3
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = naval_spotter_l
      extra4 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 0
      brigade_model4 = 1
    cost  = 6.9
    id    = { type = 23500 id = 202 }
    date  = { year = 1939 month = april day = 13 }
  }
  division_development =
  { name  = "RN ReEfBEJu["
    type  = battleship
    model = 1
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 0
    cost  = 4.8
    id    = { type = 23500 id = 203 }
    date  = { year = 1937 month = january day = 6 }
  }
  division_development =
  { name  = "RN WIE`FU["
    type  = battleship
    model = 1
      extra1 = naval_sa_l
      extra2 = naval_fire_controll_l
      extra3 = naval_anti_air_l
      brigade_model1 = 1
      brigade_model2 = 1
      brigade_model3 = 0
    cost  = 4.8
    id    = { type = 23500 id = 204 }
    date  = { year = 1937 month = january day = 10 }
  }
  division_development =
  { name  = "RN fJEfEAubcB"
    type  = light_cruiser
    model = 3
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
    cost  = 2.8
    id    = { type = 23500 id = 205 }
    date  = { year = 1937 month = december day = 1 }
  }
  division_development =
  { name  = "RN W[byEKofB"
    type  = light_cruiser
    model = 3
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
    cost  = 2.8
    id    = { type = 23500 id = 206 }
    date  = { year = 1937 month = december day = 20 }
  }
  division_development =
  { name  = "RN GEWF[jIEfBETHCA"
    type  = light_cruiser
    model = 2
      extra1 = naval_fire_controll_s
      extra2 = naval_spotter_s
      brigade_model1 = 1
      brigade_model2 = 0
    cost  = 2.1
    id    = { type = 23500 id = 29 }
    date  = { year = 1936 month = january day = 16 }
  }
  division_development =
  { name  = "10쒀"
    type  = destroyer
    model = 1
    cost  = 2.9
    id    = { type = 23500 id = 207 }
    date  = { year = 1936 month = april day = 30 }
  }
  division_development =
  { name  = "27Q"
    type  = submarine
    model = 1
    cost  = 3
    id    = { type = 23500 id = 42 }
    date  = { year = 1936 month = april day = 1 }
  }
}
